/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldDecoratingHelper;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.TopSolidOnce;

public class WaystonePlacement
extends TopSolidOnce {
    public WaystonePlacement(Codec<NoPlacementConfig> codec) {
        super(codec);
    }

    public Stream<BlockPos> getPositions(WorldDecoratingHelper helper, Random random, NoPlacementConfig config, BlockPos pos) {
        if (this.isWaystoneChunk(helper, pos)) {
            if (helper.field_242889_a.func_201672_e().func_234923_W_() == World.field_234919_h_) {
                BlockPos.Mutable mutablePos = pos.func_239590_i_();
                int topMostY = helper.func_242893_a(this.func_241858_a(config), pos.func_177958_n(), pos.func_177952_p());
                mutablePos.func_185336_p(topMostY);
                BlockState stateAbove = helper.field_242889_a.func_180495_p((BlockPos)mutablePos);
                for (int i = mutablePos.func_177956_o(); i >= 1; --i) {
                    mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
                    BlockState state = helper.field_242889_a.func_180495_p((BlockPos)mutablePos);
                    if (!state.func_196958_f() && state.func_204520_s().func_206888_e() && stateAbove.func_196958_f() && !state.func_203425_a(Blocks.field_150357_h)) {
                        mutablePos.func_185336_p(mutablePos.func_177956_o() + 1);
                        break;
                    }
                    stateAbove = state;
                }
                return mutablePos.func_177956_o() > 0 ? Stream.of(mutablePos) : Stream.empty();
            }
            return super.func_241857_a(helper, random, (IPlacementConfig)config, pos);
        }
        return Stream.empty();
    }

    private boolean isWaystoneChunk(WorldDecoratingHelper world, BlockPos pos) {
        int chunkDistance = (Integer)WaystonesConfig.COMMON.worldGenFrequency.get();
        if (chunkDistance == 0) {
            return false;
        }
        ResourceLocation dimension = world.field_242889_a.func_201672_e().func_234923_W_().func_240901_a_();
        List dimensionAllowList = (List)WaystonesConfig.COMMON.worldGenDimensionAllowList.get();
        List dimensionDenyList = (List)WaystonesConfig.COMMON.worldGenDimensionDenyList.get();
        if (!dimensionAllowList.isEmpty() && !dimensionAllowList.contains(dimension.toString())) {
            return false;
        }
        if (!dimensionDenyList.isEmpty() && dimensionDenyList.contains(dimension.toString())) {
            return false;
        }
        int maxDeviation = (int)Math.ceil((float)chunkDistance / 2.0f);
        int chunkX = pos.func_177958_n() / 16;
        int chunkZ = pos.func_177952_p() / 16;
        int devGridX = pos.func_177958_n() / 16 * maxDeviation;
        int devGridZ = pos.func_177952_p() / 16 * maxDeviation;
        long seed = world.field_242889_a.func_72905_C();
        Random random = new Random(seed * (long)devGridX * (long)devGridZ);
        int chunkOffsetX = random.nextInt(maxDeviation);
        int chunkOffsetZ = random.nextInt(maxDeviation);
        return (chunkX + chunkOffsetX) % chunkDistance == 0 && (chunkZ + chunkOffsetZ) % chunkDistance == 0;
    }
}

