/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.core.AELog;
import com.mojang.serialization.Dynamic;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public final class FixupDimensionHook {
    private FixupDimensionHook() {
    }

    public static <T> void removeDimension(Dynamic<T> nbt) {
        if (!(nbt.getValue() instanceof CompoundNBT)) {
            AELog.warn("Failed to fixup spatial dimension: Not loading from NBT", new Object[0]);
            return;
        }
        CompoundNBT compoundTag = (CompoundNBT)nbt.getValue();
        if (!compoundTag.func_150297_b("WorldGenSettings", 10)) {
            AELog.warn("Failed to fixup spatial dimension: Missing WorldGenSettings", new Object[0]);
            return;
        }
        CompoundNBT worldGenSettings = compoundTag.func_74775_l("WorldGenSettings");
        if (!worldGenSettings.func_150297_b("dimensions", 10)) {
            AELog.warn("Failed to fixup spatial dimension: Missing WorldGenSettings.dimensions", new Object[0]);
            return;
        }
        CompoundNBT dimensions = worldGenSettings.func_74775_l("dimensions");
        if (dimensions.func_74764_b("appliedenergistics2:spatial_storage")) {
            dimensions.func_82580_o("appliedenergistics2:spatial_storage");
            AELog.debug("Removed AE2 spatial storage before DFU can 'fix' it", new Object[0]);
        } else {
            AELog.warn("AE2 spatial storage dimension missing. It will be re-added.", new Object[0]);
        }
    }

    public static <T> void addDimension(Dynamic<T> nbt) {
        if (!(nbt.getValue() instanceof CompoundNBT)) {
            AELog.warn("Failed to re-add spatial dimension: Not loading from NBT", new Object[0]);
            return;
        }
        CompoundNBT worldGenSettings = (CompoundNBT)nbt.getValue();
        if (!worldGenSettings.func_150297_b("dimensions", 10)) {
            AELog.warn("Failed to re-add spatial dimension: Missing dimensions key", new Object[0]);
            return;
        }
        CompoundNBT dimensions = worldGenSettings.func_74775_l("dimensions");
        if (!dimensions.func_74764_b("appliedenergistics2:spatial_storage")) {
            AELog.debug("Re-adding spatial storage NBT to world generation settings", new Object[0]);
            CompoundNBT spatialStorage = new CompoundNBT();
            spatialStorage.func_74778_a("type", "appliedenergistics2:spatial_storage");
            CompoundNBT generator = new CompoundNBT();
            generator.func_74778_a("type", "appliedenergistics2:spatial_storage");
            spatialStorage.func_218657_a("generator", (INBT)generator);
            dimensions.func_218657_a("appliedenergistics2:spatial_storage", (INBT)spatialStorage);
        }
    }
}

