/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.fluids.container.IFluidSyncContainer;
import appeng.fluids.util.AEFluidStack;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class FluidSlotPacket
extends BasePacket {
    private final Map<Integer, IAEFluidStack> list;

    public FluidSlotPacket(PacketBuffer stream) {
        this.list = new HashMap<Integer, IAEFluidStack>();
        CompoundNBT tag = stream.func_150793_b();
        for (String key : tag.func_150296_c()) {
            this.list.put(Integer.parseInt(key), AEFluidStack.fromNBT(tag.func_74775_l(key)));
        }
    }

    public FluidSlotPacket(Map<Integer, IAEFluidStack> list) {
        this.list = list;
        CompoundNBT sendTag = new CompoundNBT();
        for (Map.Entry<Integer, IAEFluidStack> fs : list.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            if (fs.getValue() != null) {
                fs.getValue().writeToNBT(tag);
            }
            sendTag.func_218657_a(fs.getKey().toString(), (INBT)tag);
        }
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.func_150786_a(sendTag);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(INetworkInfo manager, PlayerEntity player) {
        Container c = player.field_71070_bA;
        if (c instanceof IFluidSyncContainer) {
            ((IFluidSyncContainer)c).receiveFluidSlots(this.list);
        }
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        Container c = player.field_71070_bA;
        if (c instanceof IFluidSyncContainer) {
            ((IFluidSyncContainer)c).receiveFluidSlots(this.list);
        }
    }
}

