/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.fluids;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.Platform;
import java.util.Comparator;

final class FluidSorters {
    public static final Comparator<IAEFluidStack> NAME_ASC = Comparator.comparing(fs -> Platform.getFluidDisplayName(fs).getString(), String::compareToIgnoreCase);
    public static final Comparator<IAEFluidStack> NAME_DESC = NAME_ASC.reversed();
    public static final Comparator<IAEFluidStack> MOD_ASC = Comparator.comparing(fs -> Platform.getModId(fs), String::compareToIgnoreCase).thenComparing(NAME_ASC);
    public static final Comparator<IAEFluidStack> MOD_DESC = MOD_ASC.reversed();
    public static final Comparator<IAEFluidStack> SIZE_ASC = Comparator.comparingLong(IAEStack::getStackSize);
    public static final Comparator<IAEFluidStack> SIZE_DESC = SIZE_ASC.reversed();

    private FluidSorters() {
    }

    public static Comparator<IAEFluidStack> getComparator(SortOrder order, SortDir dir) {
        switch (order) {
            default: {
                return dir == SortDir.ASCENDING ? NAME_ASC : NAME_DESC;
            }
            case AMOUNT: {
                return dir == SortDir.ASCENDING ? SIZE_ASC : SIZE_DESC;
            }
            case MOD: 
        }
        return dir == SortDir.ASCENDING ? MOD_ASC : MOD_DESC;
    }
}

