/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class BitInventoryUtils {
    private BitInventoryUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: BitInventoryUtils. This is a utility class");
    }

    public static void insertIntoOrSpawn(PlayerEntity playerEntity, BlockState blockState, int count) {
        int spawnCount;
        int leftOverCount;
        if (playerEntity == null || playerEntity.func_130014_f_().func_201670_d() || count <= 0) {
            return;
        }
        IBitInventory inventory = IBitInventoryManager.getInstance().create(playerEntity);
        if (playerEntity.func_184812_l_()) {
            if (inventory.canExtractOne(blockState)) {
                return;
            }
            if (inventory.canInsertOne(blockState)) {
                inventory.insertOne(blockState);
            }
            return;
        }
        int maxInsertionCount = inventory.getMaxInsertAmount(blockState);
        int insertionCount = Math.min(maxInsertionCount, count);
        inventory.insert(blockState, insertionCount);
        if (leftOverCount <= 0) {
            return;
        }
        for (leftOverCount = count - insertionCount; leftOverCount > 0 && (spawnCount = Math.min(IBitItemManager.getInstance().getMaxStackSize(), leftOverCount)) > 0; leftOverCount -= spawnCount) {
            ItemStack spawnStack = IBitItemManager.getInstance().create(blockState, spawnCount);
            playerEntity.func_146097_a(spawnStack, true, true);
        }
    }
}

