/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.LanguageMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public class RegistryHelper {
    private static final Map<IForgeRegistry<?>, Function<? extends ForgeRegistryEntry<?>, String>> FORGE = new HashMap();

    private static <T extends ForgeRegistryEntry<T>> void registerRegistry(IForgeRegistry<T> registry, Function<T, String> mapper) {
        FORGE.put(registry, mapper);
    }

    @Nullable
    public static <T extends ForgeRegistryEntry<T>> String translate(ResourceLocation resource) {
        for (IForgeRegistry<?> registry : FORGE.keySet()) {
            if (!registry.containsKey(resource)) continue;
            return FORGE.get(registry).apply((ForgeRegistryEntry)registry.getValue(resource));
        }
        return null;
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String name, T entry) {
        RegistryHelper.register(registry, "worldhandler", name, entry);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String modid, String name, T entry) {
        registry.register((IForgeRegistryEntry)entry.setRegistryName(new ResourceLocation(modid, name)));
    }

    static {
        RegistryHelper.registerRegistry(ForgeRegistries.BLOCKS, Block::func_149739_a);
        RegistryHelper.registerRegistry(ForgeRegistries.ITEMS, Item::func_77658_a);
        RegistryHelper.registerRegistry(ForgeRegistries.POTIONS, Effect::func_76393_a);
        RegistryHelper.registerRegistry(ForgeRegistries.BIOMES, biome -> {
            MutableRegistry registry = DynamicRegistries.func_239770_b_().func_243612_b(Registry.field_239720_u_);
            ResourceLocation resource = registry.func_177774_c(biome);
            String key = "biome." + biome.getRegistryName().func_110624_b() + "." + resource.func_110623_a();
            return LanguageMap.func_74808_a().func_230506_b_(key) ? key : resource.toString();
        });
        RegistryHelper.registerRegistry(ForgeRegistries.ENCHANTMENTS, Enchantment::func_77320_a);
        RegistryHelper.registerRegistry(ForgeRegistries.ENTITIES, EntityType::func_210760_d);
        RegistryHelper.registerRegistry(ForgeRegistries.STAT_TYPES, stat -> "stat." + stat.toString().replace(':', '.'));
    }
}

