/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.usercontent.model;

import com.google.gson.annotations.SerializedName;
import exopandora.worldhandler.usercontent.model.AbstractJsonWidget;
import exopandora.worldhandler.usercontent.model.Action;
import exopandora.worldhandler.usercontent.model.Attributes;
import exopandora.worldhandler.usercontent.model.JsonLayout;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JsonWidget
extends AbstractJsonWidget<Type> {
    @SerializedName(value="text")
    private String text;
    @SerializedName(value="type")
    private Type type;

    public JsonWidget(String text, Type type, Action action, JsonLayout layout, Attributes attributes) {
        super(action, layout, attributes);
        this.text = text;
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void validate() throws IllegalStateException {
        if (this.type == null) {
            throw new IllegalStateException("widget.type is null");
        }
        if (this.type == Type.TEXTFIELD) {
            if (this.getAttributes() == null) {
                throw new IllegalStateException("widget.attributes is null");
            }
            if (this.getAttributes().getId() == null) {
                throw new IllegalStateException("widget.attributes.id is null");
            }
            if (this.getAttributes().getId().isEmpty()) {
                throw new IllegalStateException("widget.attributes.id is empty");
            }
            this.validateAction(Action.Type.SET, Action.Type.JS);
        } else if (this.type == Type.ITEM_BUTTON) {
            if (this.getAttributes() == null) {
                throw new IllegalStateException("widget.attributes is null");
            }
            if (this.getAttributes().getItem() == null) {
                throw new IllegalStateException("widget.attributes.item is null");
            }
            this.validateAction(Action.Type.OPEN, Action.Type.SET, Action.Type.RUN, Action.Type.BACK, Action.Type.BACK_TO_GAME, Action.Type.JS);
        } else if (this.type == Type.ICON_BUTTON) {
            if (this.getAttributes() == null) {
                throw new IllegalStateException("widget.attributes is null");
            }
            if (this.getAttributes().getIcon() == null) {
                throw new IllegalStateException("widget.attributes.icon is null");
            }
            this.validateAction(Action.Type.OPEN, Action.Type.SET, Action.Type.RUN, Action.Type.BACK, Action.Type.BACK_TO_GAME, Action.Type.JS);
        } else if (this.type == Type.LIST_BUTTON) {
            if (this.getAttributes() == null) {
                throw new IllegalStateException("widget.attributes is null");
            }
            if (this.getAttributes().getItems() == null) {
                throw new IllegalStateException("widget.attributes.items is null");
            }
            if (this.getAttributes().getItems().isEmpty()) {
                throw new IllegalStateException("widget.attributes.items is empty");
            }
            this.validateAction(Action.Type.SET, Action.Type.JS);
        } else if (this.type == Type.SLIDER) {
            if (this.getAttributes() == null) {
                throw new IllegalStateException("widget.attributes is null");
            }
            this.validateAction(Action.Type.SET, Action.Type.JS);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        BUTTON,
        TEXTFIELD,
        ITEM_BUTTON,
        ICON_BUTTON,
        LIST_BUTTON,
        SLIDER;

    }
}

