/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderGeneric;
import exopandora.worldhandler.builder.impl.BuilderMultiCommand;
import exopandora.worldhandler.builder.impl.BuilderPlayer;
import exopandora.worldhandler.builder.impl.BuilderSpawnpoint;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiTextFieldTooltip;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentPlayer
extends Content {
    private Page page = Page.START;
    private GuiTextFieldTooltip posXField;
    private GuiTextFieldTooltip posYField;
    private GuiTextFieldTooltip posZField;
    private GuiTextFieldTooltip scoreField;
    private GuiTextFieldTooltip coinsField;
    private GuiTextFieldTooltip xpField;
    private final BuilderGeneric builderSetworldspawn = new BuilderGeneric("setworldspawn", new String[0]);
    private final BuilderSpawnpoint builderSpawnpoint = new BuilderSpawnpoint();
    private final BuilderPlayer builderKill = new BuilderPlayer("kill");
    private final BuilderGeneric builderClear = new BuilderGeneric("clear", new String[0]);
    private final BuilderMultiCommand builderMiscellaneous = new BuilderMultiCommand(this.builderSetworldspawn, this.builderSpawnpoint, this.builderKill, this.builderClear);

    @Override
    public ICommandBuilder getCommandBuilder() {
        if (Page.MISC.equals((Object)this.page)) {
            return this.builderMiscellaneous;
        }
        return null;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.posXField = new GuiTextFieldTooltip(x + 118, y, 114, 20);
        this.posYField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20);
        this.posZField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20);
        this.scoreField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20);
        this.coinsField = new GuiTextFieldTooltip(x + 118, y + 36, 114, 20);
        this.xpField = new GuiTextFieldTooltip(x + 118, y + 60, 114, 20);
        this.tick(container);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.player.start"), () -> {
            this.page = Page.START;
            container.func_231160_c_();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.player.score"), () -> {
            this.page = Page.SCORE;
            container.func_231160_c_();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.player.position"), () -> {
            this.page = Page.POSITION;
            container.func_231160_c_();
        });
        container.add(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.player.miscellaneous"), () -> {
            this.page = Page.MISC;
            container.func_231160_c_();
        });
        container.add(button4);
        if (Page.START.equals((Object)this.page)) {
            button1.field_230693_o_ = false;
        } else if (Page.SCORE.equals((Object)this.page)) {
            button2.field_230693_o_ = false;
        } else if (Page.POSITION.equals((Object)this.page)) {
            button3.field_230693_o_ = false;
            container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.player.position.copy_position"), () -> {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player != null) {
                    BlockPos position = player.func_233580_cy_();
                    Minecraft.func_71410_x().field_195559_v.func_197960_a(position.func_177958_n() + " " + position.func_177956_o() + " " + position.func_177952_p());
                }
            }));
        } else if (Page.MISC.equals((Object)this.page)) {
            button4.field_230693_o_ = false;
            container.add(new GuiButtonBase(x + 118, y, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.player.miscellaneous.set_spawn").func_240699_a_(TextFormatting.RED), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderSpawnpoint))));
            container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.player.miscellaneous.set_global_spawn").func_240699_a_(TextFormatting.RED), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderSetworldspawn))));
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.player.miscellaneous.kill").func_240699_a_(TextFormatting.RED), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderKill))));
            container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.entities.player.miscellaneous.clear_inventory").func_240699_a_(TextFormatting.RED), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderClear))));
        }
    }

    @Override
    public void tick(Container container) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            BlockPos position = player.func_233580_cy_();
            this.posXField.func_146180_a("X: " + position.func_177958_n());
            this.posYField.func_146180_a("Y: " + position.func_177956_o());
            this.posZField.func_146180_a("Z: " + position.func_177952_p());
            this.scoreField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.entities.player.score", (Object[])new Object[0]) + ": " + player.func_71037_bA());
            this.coinsField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.entities.player.score.experience", (Object[])new Object[0]) + ": " + player.field_71068_ca + "L");
            this.xpField.func_146180_a(I18n.func_135052_a((String)"gui.worldhandler.entities.player.score.experience_coins", (Object[])new Object[0]) + ": " + player.field_71067_cb);
        }
    }

    @Override
    public void drawScreen(MatrixStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (Page.START.equals((Object)this.page) && Minecraft.func_71410_x().field_71439_g != null) {
            int xPos = x + 175;
            int yPos = y + 82;
            int playerNameWidth = Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)Minecraft.func_71410_x().field_71439_g.func_200200_C_()) / 2;
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(container.field_230708_k_ / 2 - playerNameWidth - 1 + 59), (int)(yPos - 74), (int)(container.field_230708_k_ / 2 + playerNameWidth + 1 + 59), (int)(yPos - 65), (int)0x3F000000);
            Minecraft.func_71410_x().field_71466_p.func_243248_b(matrix, Minecraft.func_71410_x().field_71439_g.func_200200_C_(), (float)(container.field_230708_k_ / 2 - playerNameWidth + 59), (float)(yPos - 73), 0xE0E0E0);
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            InventoryScreen.func_228187_a_((int)xPos, (int)yPos, (int)30, (float)(xPos - mouseX), (float)(yPos - mouseY - 44), (LivingEntity)Minecraft.func_71410_x().field_71439_g);
            RenderSystem.defaultBlendFunc();
        } else if (Page.SCORE.equals((Object)this.page)) {
            this.scoreField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.xpField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.coinsField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        } else if (Page.POSITION.equals((Object)this.page)) {
            this.posXField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.posYField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
            this.posZField.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderSpawnpoint.setPlayer(username);
        this.builderKill.setPlayer(username);
    }

    @Override
    public Category getCategory() {
        return Categories.PLAYER;
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.player.player");
    }

    @Override
    public IFormattableTextComponent getTabTitle() {
        return new TranslationTextComponent("gui.worldhandler.tab.player.player");
    }

    @Override
    public Content getActiveContent() {
        return Contents.PLAYER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Page {
        START,
        SCORE,
        POSITION,
        MISC;

    }
}

