/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.impl.BuilderGive;
import exopandora.worldhandler.builder.impl.BuilderSetBlock;
import exopandora.worldhandler.builder.types.Coordinate;
import exopandora.worldhandler.builder.types.CoordinateInt;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonItem;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.BlockHelper;
import exopandora.worldhandler.util.CommandHelper;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentContainers
extends Content {
    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 232, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        container.add(new GuiButtonBase(x + 24, y, 208, 20, (ITextComponent)Blocks.field_150462_ai.func_235333_g_(), () -> {
            BlockHelper.setBlockNearPlayer(container.getPlayer(), Blocks.field_150462_ai);
            ActionHelper.backToGame();
        }));
        container.add(new GuiButtonBase(x + 24, y + 24, 208, 20, (ITextComponent)Blocks.field_150477_bB.func_235333_g_(), () -> {
            BlockHelper.setBlockNearPlayer(container.getPlayer(), Blocks.field_150477_bB);
            ActionHelper.backToGame();
        }));
        container.add(new GuiButtonBase(x + 24, y + 48, 208, 20, (ITextComponent)Blocks.field_150467_bQ.func_235333_g_(), () -> {
            BlockHelper.setBlockNearPlayer(container.getPlayer(), Blocks.field_150467_bQ);
            ActionHelper.backToGame();
        }));
        container.add(new GuiButtonBase(x + 24, y + 72, 208, 20, (ITextComponent)Blocks.field_150381_bn.func_235333_g_(), () -> {
            double angle = (double)Minecraft.func_71410_x().field_71439_g.func_174811_aO().func_176736_b() * Math.PI / 2.0;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                for (int yOffset = 0; yOffset <= 1; ++yOffset) {
                    for (int zOffset = 1; zOffset <= 4; ++zOffset) {
                        Block block = null;
                        int cx = (int)Math.round((double)xOffset * cos - (double)zOffset * sin);
                        int cz = (int)Math.round((double)xOffset * sin + (double)zOffset * cos);
                        if (xOffset < -1 || xOffset > 1 || zOffset >= 4) {
                            block = Blocks.field_150342_X;
                        } else if (xOffset == 0 && yOffset == 0 && zOffset == 2) {
                            block = Blocks.field_150381_bn;
                        }
                        if (block == null) continue;
                        CommandHelper.sendCommand(container.getPlayer(), new BuilderSetBlock(new CoordinateInt(cx, Coordinate.EnumType.GLOBAL), new CoordinateInt(yOffset, Coordinate.EnumType.GLOBAL), new CoordinateInt(cz, Coordinate.EnumType.GLOBAL), block.getRegistryName(), Config.getSettings().getBlockPlacingMode()));
                    }
                }
            }
            ActionHelper.backToGame();
        }));
        container.add(new GuiButtonItem(x, y, 20, 20, new ItemStack((IItemProvider)Blocks.field_150462_ai), () -> CommandHelper.sendCommand(container.getPlayer(), new BuilderGive(container.getPlayer(), Blocks.field_150462_ai.getRegistryName()))));
        container.add(new GuiButtonItem(x, y + 24, 20, 20, new ItemStack((IItemProvider)Blocks.field_150477_bB), () -> CommandHelper.sendCommand(container.getPlayer(), new BuilderGive(container.getPlayer(), Blocks.field_150477_bB.getRegistryName()))));
        container.add(new GuiButtonItem(x, y + 48, 20, 20, new ItemStack((IItemProvider)Blocks.field_150467_bQ), () -> CommandHelper.sendCommand(container.getPlayer(), new BuilderGive(container.getPlayer(), Blocks.field_150467_bQ.getRegistryName()))));
        container.add(new GuiButtonItem(x, y + 72, 20, 20, new ItemStack((IItemProvider)Blocks.field_150381_bn), () -> CommandHelper.sendCommand(container.getPlayer(), new BuilderGive(container.getPlayer(), Blocks.field_150381_bn.getRegistryName()))));
    }

    @Override
    public Category getCategory() {
        return Categories.MAIN;
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.containers");
    }

    @Override
    public IFormattableTextComponent getTabTitle() {
        return new TranslationTextComponent("gui.worldhandler.tab.containers");
    }

    @Override
    public Content getActiveContent() {
        return Contents.CONTAINERS;
    }

    @Override
    public Content getBackContent() {
        return null;
    }
}

