/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.impl;

import exopandora.worldhandler.builder.CommandSyntax;
import exopandora.worldhandler.builder.impl.BuilderBlockPos;
import exopandora.worldhandler.builder.types.ArgumentType;
import exopandora.worldhandler.builder.types.CoordinateInt;
import exopandora.worldhandler.builder.types.TargetSelector;
import exopandora.worldhandler.util.EnumHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BuilderData
extends BuilderBlockPos {
    private final TargetSelector targetSelector = new TargetSelector();

    public BuilderData() {
        super(2);
    }

    public BuilderData(EnumMode mode, ResourceLocation entity, CompoundNBT nbt) {
        this();
        this.setMode(mode);
        this.setEntity(entity);
        this.setNBT(nbt);
    }

    public BuilderData(EnumMode mode, BlockPos pos, CompoundNBT nbt) {
        this();
        this.setMode(mode);
        this.setPosition(pos);
        this.setNBT(nbt);
    }

    public void setMode(EnumMode mode) {
        EnumTarget target = this.getTarget();
        this.updateSyntax(this.getSyntax(mode, target));
        this.setMode0(mode);
        this.setTarget0(target);
    }

    private void setMode0(EnumMode mode) {
        if (mode != null) {
            this.setNode(0, mode.toString());
        }
    }

    @Nullable
    public EnumMode getMode() {
        return EnumHelper.valueOf(this.getNodeAsString(0), EnumMode.class);
    }

    public void setTarget(EnumTarget target) {
        EnumMode mode = this.getMode();
        this.updateSyntax(this.getSyntax(mode, target));
        this.setMode0(mode);
        this.setTarget0(target);
    }

    private void setTarget0(EnumTarget target) {
        if (target != null) {
            this.setNode(1, target.toString());
        }
    }

    @Nullable
    public EnumTarget getTarget() {
        return EnumHelper.valueOf(this.getNodeAsString(1), EnumTarget.class);
    }

    private void setEntity(String entity) {
        this.ensureTarget(EnumTarget.ENTITY);
        if (entity != null) {
            this.targetSelector.set("type", entity);
        }
        this.setNode(2, this.targetSelector);
    }

    public void setEntity(ResourceLocation entity) {
        this.setEntity(entity.toString());
    }

    @Nonnull
    public ResourceLocation getEntity() {
        return (ResourceLocation)this.targetSelector.get("type");
    }

    public void setPath(String path) {
        if (this.getMode() == null || !this.getMode().equals((Object)EnumMode.REMOVE)) {
            this.setMode(EnumMode.REMOVE);
        }
        switch (this.getTarget()) {
            case BLOCK: {
                this.setNode(5, path);
                break;
            }
            case ENTITY: {
                this.setNode(3, path);
                break;
            }
        }
    }

    @Override
    public void setNBT(CompoundNBT nbt) {
        EnumTarget target;
        if (this.getMode() == null || !this.getMode().equals((Object)EnumMode.MERGE)) {
            this.setMode(EnumMode.MERGE);
        }
        if ((target = this.getTarget()) != null) {
            switch (target) {
                case BLOCK: {
                    this.setNode(5, nbt);
                    break;
                }
                case ENTITY: {
                    this.setNode(3, nbt);
                    break;
                }
            }
        }
    }

    @Nullable
    public CompoundNBT getNBT() {
        if (this.getMode() != null && this.getMode().equals((Object)EnumMode.MERGE)) {
            switch (this.getTarget()) {
                case BLOCK: {
                    return this.getNodeAsNBT(5);
                }
                case ENTITY: {
                    return this.getNodeAsNBT(3);
                }
            }
        }
        return null;
    }

    @Override
    public String getCommandName() {
        return "data";
    }

    @Nullable
    private final CommandSyntax getSyntax(EnumMode mode, EnumTarget target) {
        CommandSyntax syntax = new CommandSyntax();
        syntax.addRequired(mode != null ? mode.toString() : "mode", ArgumentType.STRING);
        syntax.addRequired(target != null ? target.toString() : "target", ArgumentType.STRING);
        if (target != null) {
            switch (target) {
                case BLOCK: {
                    syntax.addRequired("x", ArgumentType.COORDINATE_INT);
                    syntax.addRequired("y", ArgumentType.COORDINATE_INT);
                    syntax.addRequired("z", ArgumentType.COORDINATE_INT);
                    break;
                }
                case ENTITY: {
                    syntax.addRequired("entity", ArgumentType.TARGET_SELECTOR);
                    break;
                }
            }
            switch (mode) {
                case GET: {
                    break;
                }
                case MERGE: {
                    syntax.addRequired("nbt", ArgumentType.NBT);
                    break;
                }
                case REMOVE: {
                    syntax.addRequired("path", ArgumentType.STRING);
                    break;
                }
            }
        } else {
            syntax.addOptional("...", ArgumentType.STRING);
        }
        return syntax;
    }

    private void ensureTarget(EnumTarget target) {
        if (this.getTarget() == null || !target.equals((Object)this.getTarget())) {
            this.setTarget(target);
        }
    }

    @Override
    public void setX(CoordinateInt x) {
        this.ensureTarget(EnumTarget.BLOCK);
        super.setX(x);
    }

    @Override
    public void setY(CoordinateInt y) {
        this.ensureTarget(EnumTarget.BLOCK);
        super.setY(y);
    }

    @Override
    public void setZ(CoordinateInt z) {
        this.ensureTarget(EnumTarget.BLOCK);
        super.setZ(z);
    }

    @Override
    @Nonnull
    public CoordinateInt getXCoordinate() {
        this.ensureTarget(EnumTarget.BLOCK);
        return super.getXCoordinate();
    }

    @Override
    @Nonnull
    public CoordinateInt getYCoordinate() {
        this.ensureTarget(EnumTarget.BLOCK);
        return super.getYCoordinate();
    }

    @Override
    @Nonnull
    public CoordinateInt getZCoordinate() {
        this.ensureTarget(EnumTarget.BLOCK);
        return super.getZCoordinate();
    }

    @Override
    @Nonnull
    public BlockPos getBlockPos() {
        this.ensureTarget(EnumTarget.BLOCK);
        return super.getBlockPos();
    }

    @Override
    public final CommandSyntax getSyntax() {
        CommandSyntax syntax = new CommandSyntax();
        syntax.addRequired("get|merge|remove", ArgumentType.STRING);
        syntax.addRequired("block|entity", ArgumentType.STRING);
        syntax.addOptional("...", ArgumentType.STRING);
        return syntax;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum EnumTarget {
        BLOCK,
        ENTITY;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum EnumMode {
        GET,
        MERGE,
        REMOVE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

