/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.PlayDiscMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.StopDiscPlaybackMessage;

public class ServerBackpackSoundHandler {
    private static final int KEEP_ALIVE_CHECK_INTERVAL = 10;
    private static final Map<RegistryKey<World>, Long> lastWorldCheck = new HashMap<RegistryKey<World>, Long>();
    private static final Map<RegistryKey<World>, Map<UUID, KeepAliveInfo>> worldBackpackKeepAlive = new HashMap<RegistryKey<World>, Map<UUID, KeepAliveInfo>>();

    private ServerBackpackSoundHandler() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ServerBackpackSoundHandler::tick);
    }

    public static void tick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.world.func_201670_d()) {
            return;
        }
        ServerWorld world = (ServerWorld)event.world;
        RegistryKey dim = world.func_234923_W_();
        if (lastWorldCheck.computeIfAbsent((RegistryKey<World>)dim, key -> world.func_82737_E()) > world.func_82737_E() - 10L || !worldBackpackKeepAlive.containsKey(dim)) {
            return;
        }
        lastWorldCheck.put((RegistryKey<World>)dim, world.func_82737_E());
        worldBackpackKeepAlive.get(dim).entrySet().removeIf(entry -> {
            if (((KeepAliveInfo)entry.getValue()).getLastKeepAliveTime() < world.func_82737_E() - 10L) {
                ServerBackpackSoundHandler.sendStopMessage(world, ((KeepAliveInfo)entry.getValue()).getLastPosition(), (UUID)entry.getKey());
                return true;
            }
            return false;
        });
    }

    public static void updateKeepAlive(UUID backpackUuid, World world, Vector3d position, Runnable onNoLongerRunning) {
        RegistryKey dim = world.func_234923_W_();
        if (!worldBackpackKeepAlive.containsKey(dim) || !worldBackpackKeepAlive.get(dim).containsKey(backpackUuid)) {
            onNoLongerRunning.run();
            return;
        }
        if (worldBackpackKeepAlive.get(dim).containsKey(backpackUuid)) {
            worldBackpackKeepAlive.get(dim).get(backpackUuid).update(world.func_82737_E(), position);
        }
    }

    public static void onSoundStopped(ServerWorld world, UUID backpackUuid) {
        ServerBackpackSoundHandler.removeKeepAliveInfo(world, backpackUuid);
    }

    public static void startPlayingDisc(ServerWorld serverWorld, BlockPos position, UUID backpackUuid, int discItemId, Runnable onStopHandler) {
        Vector3d pos = Vector3d.func_237489_a_((Vector3i)position);
        PacketHandler.sendToAllNear(serverWorld, (RegistryKey<World>)serverWorld.func_234923_W_(), pos, 128, new PlayDiscMessage(backpackUuid, discItemId, position));
        ServerBackpackSoundHandler.putKeepAliveInfo(serverWorld, backpackUuid, onStopHandler, pos);
    }

    public static void startPlayingDisc(ServerWorld serverWorld, Vector3d position, UUID backpackUuid, int entityId, int discItemId, Runnable onStopHandler) {
        PacketHandler.sendToAllNear(serverWorld, (RegistryKey<World>)serverWorld.func_234923_W_(), position, 128, new PlayDiscMessage(backpackUuid, discItemId, entityId));
        ServerBackpackSoundHandler.putKeepAliveInfo(serverWorld, backpackUuid, onStopHandler, position);
    }

    private static void putKeepAliveInfo(ServerWorld serverWorld, UUID backpackUuid, Runnable onStopHandler, Vector3d pos) {
        worldBackpackKeepAlive.computeIfAbsent((RegistryKey<World>)serverWorld.func_234923_W_(), dim -> new HashMap()).put(backpackUuid, new KeepAliveInfo(onStopHandler, serverWorld.func_82737_E(), pos));
    }

    public static void stopPlayingDisc(ServerWorld serverWorld, Vector3d position, UUID backpackUuid) {
        ServerBackpackSoundHandler.removeKeepAliveInfo(serverWorld, backpackUuid);
        ServerBackpackSoundHandler.sendStopMessage(serverWorld, position, backpackUuid);
    }

    private static void removeKeepAliveInfo(ServerWorld serverWorld, UUID backpackUuid) {
        RegistryKey dim = serverWorld.func_234923_W_();
        if (worldBackpackKeepAlive.containsKey(dim) && worldBackpackKeepAlive.get(dim).containsKey(backpackUuid)) {
            worldBackpackKeepAlive.get(dim).remove(backpackUuid).runOnStop();
        }
    }

    private static void sendStopMessage(ServerWorld serverWorld, Vector3d position, UUID backpackUuid) {
        PacketHandler.sendToAllNear(serverWorld, (RegistryKey<World>)serverWorld.func_234923_W_(), position, 128, new StopDiscPlaybackMessage(backpackUuid));
    }

    private static class KeepAliveInfo {
        private final WeakReference<Runnable> onStopHandler;
        private long lastKeepAliveTime;
        private Vector3d lastPosition;

        private KeepAliveInfo(Runnable onStopHandler, long lastKeepAliveTime, Vector3d lastPosition) {
            this.onStopHandler = new WeakReference<Runnable>(onStopHandler);
            this.lastKeepAliveTime = lastKeepAliveTime;
            this.lastPosition = lastPosition;
        }

        public long getLastKeepAliveTime() {
            return this.lastKeepAliveTime;
        }

        public Vector3d getLastPosition() {
            return this.lastPosition;
        }

        public void update(long gameTime, Vector3d position) {
            this.lastKeepAliveTime = gameTime;
            this.lastPosition = position;
        }

        public void runOnStop() {
            Runnable handler = (Runnable)this.onStopHandler.get();
            if (handler != null) {
                handler.run();
            }
        }
    }
}

