/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.loader.forge;

import com.corosus.watut.WatutNetworking;
import com.corosus.watut.loader.forge.PacketNBTFromClient;
import com.corosus.watut.loader.forge.PacketNBTFromServer;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class WatutNetworkingForge
extends WatutNetworking {
    private static final String PROTOCOL_VERSION = Integer.toString(4);
    private static short lastID = 0;
    public static final ResourceLocation NETWORK_CHANNEL_ID_MAIN = new ResourceLocation("watut", "main");
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)NETWORK_CHANNEL_ID_MAIN).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    public static void register() {
        WatutNetworkingForge.registerMessage(PacketNBTFromServer.class, PacketNBTFromServer::encode, PacketNBTFromServer::decode, PacketNBTFromServer.Handler::handle, NetworkDirection.PLAY_TO_CLIENT);
        WatutNetworkingForge.registerMessage(PacketNBTFromClient.class, PacketNBTFromClient::encode, PacketNBTFromClient::decode, PacketNBTFromClient.Handler::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    private static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer, NetworkDirection networkDirection) {
        HANDLER.registerMessage((int)lastID, messageType, encoder, decoder, messageConsumer, Optional.ofNullable(networkDirection));
        lastID = (short)(lastID + 1);
        if (lastID > 255) {
            throw new RuntimeException("Too many messages!");
        }
    }

    @Override
    public void clientSendToServer(CompoundNBT data) {
        HANDLER.sendTo((Object)new PacketNBTFromClient(data), Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147298_b(), NetworkDirection.PLAY_TO_SERVER);
    }

    @Override
    public void serverSendToClientAll(CompoundNBT data) {
        HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new PacketNBTFromServer(data));
    }

    @Override
    public void serverSendToClientPlayer(CompoundNBT data, PlayerEntity player) {
        HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PacketNBTFromServer(data));
    }

    @Override
    public void serverSendToClientNear(CompoundNBT data, Vector3d pos, double dist, World level) {
        HANDLER.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dist, level.func_234923_W_())), (Object)new PacketNBTFromServer(data));
    }
}

