/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.config.ConfigCommon;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PlayerStatusManagerServer
extends PlayerStatusManager {
    @Override
    public void tickPlayer(PlayerEntity player) {
        this.getStatus(player).setTicksToMarkPlayerIdleSyncedForClient(ConfigCommon.ticksToMarkPlayerIdle);
        super.tickPlayer(player);
    }

    public void receiveAny(PlayerEntity player, CompoundNBT data) {
        data.func_74778_a(WatutNetworking.NBTDataPlayerUUID, player.func_110124_au().toString());
        if (data.func_74764_b(WatutNetworking.NBTDataPlayerStatus)) {
            PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.func_74762_e(WatutNetworking.NBTDataPlayerStatus));
            this.getStatus(player).setPlayerGuiState(playerGuiState);
        }
        if (data.func_74764_b(WatutNetworking.NBTDataPlayerIdleTicks)) {
            this.handleIdleState(player, data.func_74762_e(WatutNetworking.NBTDataPlayerIdleTicks));
            data.func_74768_a(WatutNetworking.NBTDataPlayerTicksToGoIdle, ConfigCommon.ticksToMarkPlayerIdle);
        }
        if (data.func_74764_b(WatutNetworking.NBTDataPlayerMouseX)) {
            float x = data.func_74760_g(WatutNetworking.NBTDataPlayerMouseX);
            float y = data.func_74760_g(WatutNetworking.NBTDataPlayerMouseY);
            boolean pressed = data.func_74767_n(WatutNetworking.NBTDataPlayerMousePressed);
            this.setMouse(player.func_110124_au(), x, y, pressed);
        }
        this.getStatus(player).getNbtCache().func_197643_a(data);
        if (data.func_74764_b(WatutNetworking.NBTDataPlayerStatus) || data.func_74764_b(WatutNetworking.NBTDataPlayerIdleTicks)) {
            WatutNetworking.instance().serverSendToClientAll(data);
        } else {
            WatutNetworking.instance().serverSendToClientNear(data, player.func_213303_ch(), this.nearbyPlayerDataSendDist, player.field_70170_p);
        }
    }

    public void handleIdleState(PlayerEntity player, int idleTicks) {
        PlayerStatus status = this.getStatus(player);
        if (WatutMod.instance().getPlayerList().func_72394_k() > 1 || this.singleplayerTesting) {
            if (idleTicks > ConfigCommon.ticksToMarkPlayerIdle) {
                if (!status.isIdle()) {
                    this.broadcast(player.func_145748_c_().getString() + " has gone idle");
                }
            } else if (status.isIdle()) {
                this.broadcast(player.func_145748_c_().getString() + " is no longer idle");
            }
        }
        status.setTicksSinceLastAction(idleTicks);
    }

    public void broadcast(String msg) {
        if (ConfigCommon.announceIdleStatesInChat) {
            WatutMod.instance().getPlayerList().func_232641_a_((ITextComponent)new StringTextComponent(msg), ChatType.CHAT, new UUID(0L, 0L));
        }
    }

    @Override
    public void playerLoggedIn(PlayerEntity player) {
        super.playerLoggedIn(player);
        WatutMod.dbg("player logged in");
        if (player instanceof ServerPlayerEntity) {
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("sending update all packet for " + ((UUID)entry.getKey()).toString() + " to " + player.func_145748_c_().getString() + " with status " + (Object)((Object)PlayerStatus.PlayerGuiState.get(((PlayerStatus)entry.getValue()).getNbtCache().func_74762_e(WatutNetworking.NBTDataPlayerStatus))));
                WatutNetworking.instance().serverSendToClientPlayer(((PlayerStatus)entry.getValue()).getNbtCache(), player);
            }
        }
    }
}

