/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.IngredientBlacklistType;
import mezz.jei.config.KeyBindings;
import mezz.jei.events.EventBusHelper;
import mezz.jei.gui.Focus;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.LeftAreaDispatcher;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.CombinedMouseHandler;
import mezz.jei.input.GuiContainerWrapper;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseDragHandler;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.LimitedAreaMouseHandler;
import mezz.jei.input.MouseUtil;
import mezz.jei.input.click.ClickFocusHandler;
import mezz.jei.input.click.GuiAreaClickHandler;
import mezz.jei.input.click.MouseClickState;
import mezz.jei.util.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InputHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IIngredientManager ingredientManager;
    private final WeakReference<IngredientFilter> weakIngredientFilter;
    private final RecipesGui recipesGui;
    private final IngredientListOverlay ingredientListOverlay;
    private final IEditModeConfig editModeConfig;
    private final IWorldConfig worldConfig;
    private final GuiScreenHelper guiScreenHelper;
    private final LeftAreaDispatcher leftAreaDispatcher;
    private final BookmarkList bookmarkList;
    private final List<IShowsRecipeFocuses> showsRecipeFocuses = new ArrayList<IShowsRecipeFocuses>();
    private final IMouseHandler mouseClickHandler;
    private final IMouseDragHandler mouseDragHandler;

    public InputHandler(RecipesGui recipesGui, IngredientFilter ingredientFilter, IngredientManager ingredientManager, IngredientListOverlay ingredientListOverlay, IEditModeConfig editModeConfig, IWorldConfig worldConfig, GuiScreenHelper guiScreenHelper, LeftAreaDispatcher leftAreaDispatcher, BookmarkList bookmarkList) {
        this.ingredientManager = ingredientManager;
        this.weakIngredientFilter = new WeakReference<IngredientFilter>(ingredientFilter);
        this.recipesGui = recipesGui;
        this.ingredientListOverlay = ingredientListOverlay;
        this.editModeConfig = editModeConfig;
        this.worldConfig = worldConfig;
        this.guiScreenHelper = guiScreenHelper;
        this.leftAreaDispatcher = leftAreaDispatcher;
        this.bookmarkList = bookmarkList;
        this.showsRecipeFocuses.add(recipesGui);
        this.showsRecipeFocuses.add(ingredientListOverlay);
        this.showsRecipeFocuses.add(leftAreaDispatcher);
        this.showsRecipeFocuses.add(new GuiContainerWrapper(guiScreenHelper));
        this.mouseClickHandler = new CombinedMouseHandler(new ClickEditHandler(), ingredientListOverlay.getMouseHandler(), leftAreaDispatcher.getMouseHandler(), new ClickFocusHandler(this, recipesGui), new ClickGlobalHandler(), new GuiAreaClickHandlerGenerator());
        this.mouseDragHandler = ingredientListOverlay.getMouseDragHandler();
    }

    public void registerToEventBus() {
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.InitGuiEvent.class, InputHandler::onInitGuiEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.KeyboardKeyPressedEvent.Pre.class, InputHandler::onGuiKeyPressedEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.KeyboardCharTypedEvent.Pre.class, InputHandler::onGuiCharTypedEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.KeyboardKeyPressedEvent.Post.class, InputHandler::onGuiKeyboardEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.KeyboardCharTypedEvent.Post.class, InputHandler::onGuiCharTypedEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.MouseClickedEvent.Pre.class, InputHandler::onGuiMouseEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.MouseReleasedEvent.Pre.class, InputHandler::onGuiMouseEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.MouseScrollEvent.Pre.class, InputHandler::onGuiMouseEvent);
    }

    public void onInitGuiEvent(GuiScreenEvent.InitGuiEvent event) {
        this.mouseClickHandler.handleMouseClickedOut(0);
        this.mouseClickHandler.handleMouseClickedOut(1);
        this.mouseClickHandler.handleMouseClickedOut(2);
        this.mouseDragHandler.handleDragCanceled();
    }

    public void onGuiKeyPressedEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (this.hasKeyboardFocus()) {
            this.handleKeyEvent(event.getKeyCode(), event.getScanCode(), event.getModifiers());
            event.setCanceled(true);
        }
    }

    public void onGuiCharTypedEvent(GuiScreenEvent.KeyboardCharTypedEvent.Pre event) {
        if (this.hasKeyboardFocus() && this.handleCharTyped(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Post event) {
        if (!this.hasKeyboardFocus() && this.handleKeyEvent(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    public void onGuiCharTypedEvent(GuiScreenEvent.KeyboardCharTypedEvent.Post event) {
        if (!this.hasKeyboardFocus() && this.handleCharTyped(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    public void onGuiMouseEvent(GuiScreenEvent.MouseClickedEvent.Pre event) {
        int mouseButton = event.getButton();
        if (mouseButton > -1) {
            Screen screen = event.getGui();
            double mouseX = event.getMouseX();
            double mouseY = event.getMouseY();
            IMouseHandler handler = this.mouseClickHandler.handleClick(screen, mouseX, mouseY, mouseButton, MouseClickState.SIMULATE);
            IMouseDragHandler dragHandler = null;
            if (mouseButton == 0) {
                dragHandler = this.mouseDragHandler.handleDragStart(screen, mouseX, mouseY);
            }
            if (handler != null || dragHandler != null) {
                event.setCanceled(true);
            }
        }
    }

    public void onGuiMouseEvent(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        int mouseButton = event.getButton();
        if (mouseButton > -1) {
            Screen screen = event.getGui();
            double mouseX = event.getMouseX();
            double mouseY = event.getMouseY();
            IMouseHandler handled = this.mouseClickHandler.handleClick(screen, mouseX, mouseY, mouseButton, MouseClickState.EXECUTE);
            IMouseDragHandler dragHandled = null;
            if (mouseButton == 0) {
                dragHandled = this.mouseDragHandler.handleDragComplete(screen, mouseX, mouseY);
            }
            if (handled != null || dragHandled != null) {
                event.setCanceled(true);
            }
        }
    }

    public void onGuiMouseEvent(GuiScreenEvent.MouseScrollEvent.Pre event) {
        double dWheel = event.getScrollDelta();
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        IMouseHandler overlayMouseHandler = this.ingredientListOverlay.getMouseHandler();
        if (overlayMouseHandler.handleMouseScrolled(mouseX, mouseY, dWheel) || this.leftAreaDispatcher.handleMouseScrolled(mouseX, mouseY, dWheel)) {
            event.setCanceled(true);
        }
    }

    @Nullable
    public IClickedIngredient<?> getFocusUnderMouseForClick(double mouseX, double mouseY, int mouseButton) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            IClickedIngredient<?> clicked;
            if (InputHandler.isConflictingVanillaMouseButton(mouseButton) && !gui.canSetFocusWithMouse() || (clicked = gui.getIngredientUnderMouse(mouseX, mouseY)) == null) continue;
            return clicked;
        }
        return null;
    }

    private static boolean isConflictingVanillaMouseButton(int mouseButton) {
        return mouseButton <= 2;
    }

    @Nullable
    private IClickedIngredient<?> getIngredientUnderMouseForKey(double mouseX, double mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            IClickedIngredient<?> clicked = gui.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked == null) continue;
            return clicked;
        }
        return null;
    }

    private boolean hasKeyboardFocus() {
        return this.ingredientListOverlay.hasKeyboardFocus();
    }

    private boolean handleCharTyped(char codePoint, int modifiers) {
        return this.ingredientListOverlay.onCharTyped(codePoint, modifiers);
    }

    private boolean handleKeyEvent(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (this.ingredientListOverlay.hasKeyboardFocus()) {
            if (KeyBindings.isInventoryCloseKey(input) || KeyBindings.isEnterKey(keyCode)) {
                this.ingredientListOverlay.clearKeyboardFocus();
                return true;
            }
            if (this.ingredientListOverlay.onKeyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        if (this.handleGlobalKeybinds(input, MouseClickState.VANILLA)) {
            return true;
        }
        if (!this.isContainerTextFieldFocused() && !this.ingredientListOverlay.hasKeyboardFocus()) {
            IClickedIngredient<?> clicked = this.getIngredientUnderMouseForKey(MouseUtil.getX(), MouseUtil.getY());
            if (clicked != null && this.handleFocusKeybinds(clicked, input, MouseClickState.VANILLA)) {
                this.ingredientListOverlay.clearKeyboardFocus();
                return true;
            }
            return this.ingredientListOverlay.onKeyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private boolean handleGlobalKeybinds(InputMappings.Input input, MouseClickState clickState) {
        if (KeyBindings.toggleOverlay.isActiveAndMatches(input)) {
            if (!clickState.isSimulate()) {
                this.worldConfig.toggleOverlayEnabled();
            }
            return true;
        }
        if (KeyBindings.toggleBookmarkOverlay.isActiveAndMatches(input)) {
            if (!clickState.isSimulate()) {
                this.worldConfig.toggleBookmarkEnabled();
            }
            return true;
        }
        return this.ingredientListOverlay.onGlobalKeyPressed(input, clickState);
    }

    public boolean handleFocusKeybinds(IClickedIngredient<?> clicked, InputMappings.Input input, MouseClickState clickState) {
        boolean showRecipe = KeyBindings.showRecipe.isActiveAndMatches(input);
        boolean showUses = KeyBindings.showUses.isActiveAndMatches(input);
        if (showRecipe || showUses) {
            if (!clickState.isSimulate()) {
                IFocus.Mode mode = showRecipe ? IFocus.Mode.OUTPUT : IFocus.Mode.INPUT;
                this.recipesGui.show(new Focus(mode, clicked.getValue()));
            }
            this.ingredientListOverlay.clearKeyboardFocus();
            return true;
        }
        if (KeyBindings.bookmark.isActiveAndMatches(input)) {
            if (!clickState.isSimulate()) {
                if (this.bookmarkList.remove(clicked.getValue())) {
                    if (this.bookmarkList.isEmpty()) {
                        this.worldConfig.setBookmarkEnabled(false);
                    }
                    return true;
                }
                this.worldConfig.setBookmarkEnabled(true);
                return this.bookmarkList.add(clicked.getValue());
            }
            this.ingredientListOverlay.clearKeyboardFocus();
            return true;
        }
        return false;
    }

    private boolean isContainerTextFieldFocused() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null) {
            return false;
        }
        Screen screen = minecraft.field_71462_r;
        if (screen == null) {
            return false;
        }
        TextFieldWidget textField = ReflectionUtil.getFieldWithClass(screen, TextFieldWidget.class);
        return textField != null && textField.func_146176_q() && textField.func_230999_j_();
    }

    public class GuiAreaClickHandlerGenerator
    implements IMouseHandler {
        @Override
        @Nullable
        public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            if (screen instanceof ContainerScreen) {
                ContainerScreen guiContainer = (ContainerScreen)screen;
                IGuiClickableArea clickableArea = InputHandler.this.guiScreenHelper.getGuiClickableArea(guiContainer, mouseX - (double)guiContainer.getGuiLeft(), mouseY - (double)guiContainer.getGuiTop());
                if (clickableArea != null) {
                    return new GuiAreaClickHandler(InputHandler.this.recipesGui, clickableArea, guiContainer);
                }
            }
            return null;
        }
    }

    public class ClickGlobalHandler
    implements IMouseHandler {
        @Override
        public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(mouseButton);
            if (InputHandler.this.handleGlobalKeybinds(input, clickState)) {
                return this;
            }
            return null;
        }
    }

    public class ClickEditHandler
    implements IMouseHandler {
        @Override
        public IMouseHandler handleClick(Screen screen, double mouseX, double mouseY, int mouseButton, MouseClickState clickState) {
            if (!InputHandler.this.worldConfig.isEditModeEnabled()) {
                return null;
            }
            IClickedIngredient<?> clicked = InputHandler.this.getFocusUnderMouseForClick(mouseX, mouseY, mouseButton);
            if (clicked == null) {
                return null;
            }
            if (!clickState.isSimulate()) {
                this.handler(clicked);
            }
            return LimitedAreaMouseHandler.create(this, clicked.getArea());
        }

        private <V> void handler(IClickedIngredient<V> clicked) {
            V ingredient = clicked.getValue();
            IngredientBlacklistType blacklistType = Screen.func_231172_r_() ? IngredientBlacklistType.WILDCARD : IngredientBlacklistType.ITEM;
            IIngredientHelper<V> ingredientHelper = InputHandler.this.ingredientManager.getIngredientHelper(ingredient);
            IngredientFilter ingredientFilter = (IngredientFilter)InputHandler.this.weakIngredientFilter.get();
            if (ingredientFilter == null) {
                LOGGER.error("Can't edit the config blacklist, the ingredient filter is null");
            } else if (InputHandler.this.editModeConfig.isIngredientOnConfigBlacklist(ingredient, ingredientHelper)) {
                InputHandler.this.editModeConfig.removeIngredientFromConfigBlacklist(ingredient, blacklistType, ingredientHelper);
            } else {
                InputHandler.this.editModeConfig.addIngredientToConfigBlacklist(ingredient, blacklistType, ingredientHelper);
            }
        }
    }
}

