/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.utils;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    public static final ItemStack EMPTY = ItemStack.field_190927_a;
    @NotNull
    public static final Predicate<ItemStack> EMPTY_PREDICATE = ItemStackUtils::isEmpty;
    @NotNull
    public static final Predicate<ItemStack> NOT_EMPTY_PREDICATE = EMPTY_PREDICATE.negate();

    private ItemStackUtils() {
    }

    @NotNull
    public static Boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack.func_190926_b();
    }

    public static Boolean isNotEmpty(@Nullable ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false;
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, true, true);
    }

    public static int getSize(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.func_190916_E();
    }

    public static int getDurability(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.func_77958_k() - stack.func_77952_i();
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min) {
        if (ItemStackUtils.isEmpty(itemStack1).booleanValue() && ItemStackUtils.isEmpty(itemStack2).booleanValue()) {
            return true;
        }
        if (ItemStackUtils.isEmpty(itemStack1) != ItemStackUtils.isEmpty(itemStack2)) {
            return false;
        }
        if (!(itemStack1.func_77973_b() != itemStack2.func_77973_b() || matchDamage && itemStack1.func_77952_i() != itemStack2.func_77952_i())) {
            if (!matchNBT) {
                return true;
            }
            if (min && itemStack1.func_190916_E() > itemStack2.func_190916_E()) {
                return false;
            }
            if (itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                CompoundNBT nbt1 = itemStack1.func_77978_p();
                CompoundNBT nbt2 = itemStack2.func_77978_p();
                for (String key : nbt1.func_150296_c()) {
                    if (!matchDamage && key.equals("Damage") || nbt2.func_74764_b(key) && nbt1.func_74781_a(key).equals(nbt2.func_74781_a(key))) continue;
                    return false;
                }
                return nbt1.func_186856_d() == nbt2.func_186856_d();
            }
            return !(itemStack1.func_77942_o() && !itemStack1.func_77978_p().isEmpty() || itemStack2.func_77942_o() && !itemStack2.func_77978_p().isEmpty());
        }
        return false;
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack) {
        return ItemStackUtils.compareItemStackListIgnoreStackSize(stacks, stack, true, true);
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack, boolean matchDamage, boolean matchNBT) {
        for (ItemStack tempStack : stacks) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(tempStack, stack, matchDamage, matchNBT)) continue;
            return true;
        }
        return false;
    }

    public static void changeSize(@NotNull ItemStack stack, int amount) {
        stack.func_190920_e(stack.func_190916_E() + amount);
    }
}

