/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.handlers;

import java.util.Optional;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.client.screen.AbstractChiselsAndBitsScreen;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.screens.widgets.ChangeTrackerOperationsWidget;
import mod.chiselsandbits.profiling.ProfilingManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class ClientPacketHandlers {
    private ClientPacketHandlers() {
        throw new IllegalStateException("Can not instantiate an instance of: ClientPacketHandlers. This is a utility class");
    }

    public static void handleTileEntityUpdatedPacket(BlockPos blockPos, CompoundNBT updateTag) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(blockPos);
            if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                Optional<Block> convertedState;
                BlockState currentState;
                BlockState initializationState = currentState = Minecraft.func_71410_x().field_71441_e.func_180495_p(blockPos);
                if (currentState.func_196958_f()) {
                    currentState = Blocks.field_150348_b.func_176223_P();
                }
                if (!(convertedState = IConversionManager.getInstance().getChiseledVariantOf(currentState)).isPresent()) {
                    return;
                }
                Minecraft.func_71410_x().field_71441_e.func_180501_a(blockPos, convertedState.get().func_176223_P(), 3);
                tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(blockPos);
                if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                    return;
                }
            }
            if (tileEntity != null && tileEntity.func_145831_w() != null) {
                try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Handling tile entity update packet");){
                    try (IProfilerSection ignored2 = ProfilingManager.getInstance().withSection("Updating tile entity");){
                        tileEntity.handleUpdateTag(Minecraft.func_71410_x().field_71441_e.func_180495_p(blockPos), updateTag);
                    }
                    ignored2 = ProfilingManager.getInstance().withSection("Scheduling refresh");
                    try {
                        tileEntity.func_145831_w().func_184138_a(tileEntity.func_174877_v(), Blocks.field_150350_a.func_176223_P(), tileEntity.func_195044_w(), 11);
                    }
                    finally {
                        if (ignored2 != null) {
                            ignored2.close();
                        }
                    }
                }
            }
        }
    }

    public static void handleChangeTrackerUpdated(CompoundNBT tag) {
        IChangeTrackerManager.getInstance().getChangeTracker((PlayerEntity)Minecraft.func_71410_x().field_71439_g).deserializeNBT((INBT)tag);
        if (Minecraft.func_71410_x().field_71462_r instanceof AbstractChiselsAndBitsScreen) {
            ((AbstractChiselsAndBitsScreen)Minecraft.func_71410_x().field_71462_r).getWidgets().stream().filter(ChangeTrackerOperationsWidget.class::isInstance).map(ChangeTrackerOperationsWidget.class::cast).forEach(ChangeTrackerOperationsWidget::updateState);
        }
    }

    public static void handleNeighborUpdated(BlockPos toUpdate, BlockPos from) {
        Minecraft.func_71410_x().field_71441_e.func_180495_p(toUpdate).func_215697_a((World)Minecraft.func_71410_x().field_71441_e, toUpdate, Minecraft.func_71410_x().field_71441_e.func_180495_p(from).func_177230_c(), from, false);
    }
}

