/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities;

import java.util.Objects;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.item.chisel.IChiselItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.pattern.IMultiUsePatternItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.block.ChiseledPrinterBlock;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import mod.chiselsandbits.container.ChiseledPrinterContainer;
import mod.chiselsandbits.registrars.ModTileEntityTypes;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledPrinterBlockEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final LazyOptional<EmptyHandler> empty_handler = LazyOptional.of((NonNullSupplier)NonNullLazy.of(EmptyHandler::new));
    private final LazyOptional<ItemStackHandler> tool_handler = LazyOptional.of((NonNullSupplier)NonNullLazy.of(() -> new ItemStackHandler(1){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.func_77973_b() instanceof IChiselItem;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }));
    private final LazyOptional<ItemStackHandler> pattern_handler = LazyOptional.of((NonNullSupplier)NonNullLazy.of(() -> new ItemStackHandler(1){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.func_77973_b() instanceof IMultiUsePatternItem;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            ChiseledPrinterBlockEntity.this.currentRealisedWorkingStack.setValue((Object)ItemStack.field_190927_a);
        }
    }));
    private final LazyOptional<ItemStackHandler> result_handler = LazyOptional.of((NonNullSupplier)NonNullLazy.of(() -> new ItemStackHandler(1){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }
    }));
    protected final IIntArray stationData = new IIntArray(){

        public int func_221476_a(int index) {
            if (index == 0) {
                return ChiseledPrinterBlockEntity.this.progress;
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            if (index == 0) {
                ChiseledPrinterBlockEntity.this.progress = value;
            }
        }

        public int func_221478_a() {
            return 1;
        }
    };
    private int progress = 0;
    private long lastTickTime = 0L;
    private final MutableObject<ItemStack> currentRealisedWorkingStack = new MutableObject((Object)ItemStack.field_190927_a);

    public ChiseledPrinterBlockEntity() {
        super((TileEntityType)ModTileEntityTypes.CHISELED_PRINTER.get());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return super.getCapability(cap, side);
        }
        if (side != null) {
            switch (side) {
                case DOWN: {
                    return this.result_handler.cast();
                }
                case UP: 
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    return this.tool_handler.cast();
                }
            }
        }
        return this.empty_handler.cast();
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.tool_handler.ifPresent(h -> h.deserializeNBT(nbt.func_74775_l("tool")));
        this.pattern_handler.ifPresent(h -> h.deserializeNBT(nbt.func_74775_l("pattern")));
        this.result_handler.ifPresent(h -> h.deserializeNBT(nbt.func_74775_l("result")));
        this.progress = nbt.func_74762_e("progress");
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        super.func_189515_b(compound);
        this.tool_handler.ifPresent(h -> compound.func_218657_a("tool", (INBT)h.serializeNBT()));
        this.pattern_handler.ifPresent(h -> compound.func_218657_a("pattern", (INBT)h.serializeNBT()));
        this.result_handler.ifPresent(h -> compound.func_218657_a("result", (INBT)h.serializeNBT()));
        compound.func_74768_a("progress", this.progress);
        return compound;
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void func_73660_a() {
        if (this.func_145831_w() == null || this.lastTickTime == this.func_145831_w().func_82737_E() || this.func_145831_w().func_201670_d()) {
            return;
        }
        this.lastTickTime = this.func_145831_w().func_82737_E();
        if (this.couldWork()) {
            if (this.canWork()) {
                ++this.progress;
                if (this.progress >= 100) {
                    this.result_handler.ifPresent(h -> h.insertItem(0, this.realisePattern(true), false));
                    this.currentRealisedWorkingStack.setValue((Object)ItemStack.field_190927_a);
                    this.progress = 0;
                    this.damageChisel();
                }
                this.func_70296_d();
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.func_70296_d();
        }
    }

    public IItemHandlerModifiable getPatternHandler() {
        return (IItemHandlerModifiable)this.pattern_handler.orElseThrow(() -> new IllegalStateException("Missing empty handler."));
    }

    public IItemHandlerModifiable getToolHandler() {
        return (IItemHandlerModifiable)this.tool_handler.orElseThrow(() -> new IllegalStateException("Missing tool handler."));
    }

    public IItemHandlerModifiable getResultHandler() {
        return (IItemHandlerModifiable)this.result_handler.orElseThrow(() -> new IllegalStateException("Missing result handler."));
    }

    public boolean hasPatternStack() {
        return !this.getPatternStack().func_190926_b();
    }

    public boolean hasToolStack() {
        return !this.getToolStack().func_190926_b();
    }

    public boolean hasRealisedStack() {
        return !this.getRealisedStack().func_190926_b();
    }

    public boolean hasOutputStack() {
        return !this.getOutputStack().func_190926_b();
    }

    public boolean canMergeOutputs() {
        if (!this.hasOutputStack()) {
            return true;
        }
        if (!this.hasRealisedStack()) {
            return false;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.getOutputStack(), (ItemStack)this.getRealisedStack());
    }

    public boolean canWork() {
        return this.hasPatternStack() && this.hasToolStack() && this.canMergeOutputs() && !this.getRealisedStack().func_190926_b();
    }

    public boolean couldWork() {
        return this.hasPatternStack() && this.hasToolStack();
    }

    public ItemStack getPatternStack() {
        return this.pattern_handler.map(h -> h.getStackInSlot(0)).orElse(ItemStack.field_190927_a);
    }

    public ItemStack getToolStack() {
        return this.tool_handler.map(h -> h.getStackInSlot(0)).orElse(ItemStack.field_190927_a);
    }

    public ItemStack getRealisedStack() {
        ItemStack realisedStack = (ItemStack)this.currentRealisedWorkingStack.getValue();
        if (realisedStack.func_190926_b()) {
            realisedStack = this.realisePattern(false);
            this.currentRealisedWorkingStack.setValue((Object)realisedStack);
        }
        return realisedStack;
    }

    public ItemStack getOutputStack() {
        return this.result_handler.map(h -> h.getStackInSlot(0)).orElse(ItemStack.field_190927_a);
    }

    private ItemStack realisePattern(boolean consumeResources) {
        BlockState thirdState;
        if (!this.hasPatternStack()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.getPatternStack();
        if (!(stack.func_77973_b() instanceof IPatternItem)) {
            return ItemStack.field_190927_a;
        }
        IPatternItem patternItem = (IPatternItem)stack.func_77973_b();
        IMultiStateItemStack realisedPattern = patternItem.createItemStack(stack);
        if (realisedPattern.getStatistics().isEmpty()) {
            return ItemStack.field_190927_a;
        }
        BlockState firstState = this.getPrimaryBlockState() == null ? Blocks.field_150350_a.func_176223_P() : this.getPrimaryBlockState();
        BlockState secondState = this.getSecondaryBlockState() == null ? Blocks.field_150350_a.func_176223_P() : this.getSecondaryBlockState();
        BlockState blockState = thirdState = this.getTertiaryBlockState() == null ? Blocks.field_150350_a.func_176223_P() : this.getTertiaryBlockState();
        if (firstState.func_196958_f() && secondState.func_196958_f() && thirdState.func_196958_f()) {
            return ItemStack.field_190927_a;
        }
        if (!IEligibilityManager.getInstance().canBeChiseled(firstState) && !firstState.func_196958_f() || !IEligibilityManager.getInstance().canBeChiseled(secondState) && !secondState.func_196958_f() || !IEligibilityManager.getInstance().canBeChiseled(thirdState) && !thirdState.func_196958_f()) {
            return ItemStack.field_190927_a;
        }
        IMultiStateSnapshot modifiableSnapshot = realisedPattern.createSnapshot();
        modifiableSnapshot.mutableStream().filter(e -> !(e.getState() == firstState && firstState != Blocks.field_150350_a.func_176223_P() || e.getState() == secondState && secondState != Blocks.field_150350_a.func_176223_P() || e.getState() == thirdState && thirdState != Blocks.field_150350_a.func_176223_P() || e.getState() == Blocks.field_150350_a.func_176223_P())).forEach(IMutableStateEntryInfo::clear);
        if (modifiableSnapshot.getStatics().getStateCounts().getOrDefault(firstState, 0) == 0 && modifiableSnapshot.getStatics().getStateCounts().getOrDefault(secondState, 0) == 0 && modifiableSnapshot.getStatics().getStateCounts().getOrDefault(thirdState, 0) == 0) {
            return ItemStack.field_190927_a;
        }
        if (modifiableSnapshot.getStatics().getStateCounts().getOrDefault(firstState, 0) > this.getAvailablePrimaryBlockState() && firstState != Blocks.field_150350_a.func_176223_P() || modifiableSnapshot.getStatics().getStateCounts().getOrDefault(secondState, 0) > this.getAvailableSecondaryBlockState() && secondState != Blocks.field_150350_a.func_176223_P() || modifiableSnapshot.getStatics().getStateCounts().getOrDefault(thirdState, 0) > this.getAvailableTertiaryBlockState() && thirdState != Blocks.field_150350_a.func_176223_P()) {
            return ItemStack.field_190927_a;
        }
        if (consumeResources) {
            this.drainPrimaryStorage(modifiableSnapshot.getStatics().getStateCounts().getOrDefault(firstState, 0));
            this.drainSecondaryStorage(modifiableSnapshot.getStatics().getStateCounts().getOrDefault(secondState, 0));
            this.drainTertiaryStorage(modifiableSnapshot.getStatics().getStateCounts().getOrDefault(thirdState, 0));
        }
        return modifiableSnapshot.toItemStack().toBlockStack();
    }

    private void damageChisel() {
        if (this.func_145831_w() != null && !this.func_145831_w().func_201670_d()) {
            this.getToolStack().func_96631_a(1, this.func_145831_w().func_201674_k(), null);
        }
    }

    @Nullable
    public Container createMenu(int containerId, @NotNull PlayerInventory playerInventory, @NotNull PlayerEntity playerEntity) {
        return new ChiseledPrinterContainer(containerId, playerInventory, this.getPatternHandler(), this.getToolHandler(), this.getResultHandler(), this.stationData);
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return LocalStrings.ChiselStationName.getText();
    }

    public int getAvailablePrimaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.func_145831_w()).func_180495_p(this.func_174877_v()).func_177229_b((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.func_176746_e();
        return this.getStorageContents(targetedFacing);
    }

    public int getAvailableSecondaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.func_145831_w()).func_180495_p(this.func_174877_v()).func_177229_b((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.func_176746_e().func_176746_e();
        return this.getStorageContents(targetedFacing);
    }

    public int getAvailableTertiaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.func_145831_w()).func_180495_p(this.func_174877_v()).func_177229_b((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.func_176735_f();
        return this.getStorageContents(targetedFacing);
    }

    private int getStorageContents(Direction targetedFacing) {
        TileEntity targetedTileEntity = Objects.requireNonNull(this.func_145831_w()).func_175625_s(this.func_174877_v().func_177972_a(targetedFacing));
        if (targetedTileEntity instanceof BitStorageBlockEntity) {
            BitStorageBlockEntity storage = (BitStorageBlockEntity)targetedTileEntity;
            return storage.getBits();
        }
        return 0;
    }

    public BlockState getPrimaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.func_145831_w()).func_180495_p(this.func_174877_v()).func_177229_b((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.func_176746_e();
        return this.getStorage(targetedFacing);
    }

    public BlockState getSecondaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.func_145831_w()).func_180495_p(this.func_174877_v()).func_177229_b((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.func_176746_e().func_176746_e();
        return this.getStorage(targetedFacing);
    }

    public BlockState getTertiaryBlockState() {
        Direction facing = (Direction)Objects.requireNonNull(this.func_145831_w()).func_180495_p(this.func_174877_v()).func_177229_b((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.func_176735_f();
        return this.getStorage(targetedFacing);
    }

    private BlockState getStorage(Direction targetedFacing) {
        TileEntity targetedTileEntity = Objects.requireNonNull(this.func_145831_w()).func_175625_s(this.func_174877_v().func_177972_a(targetedFacing));
        if (targetedTileEntity instanceof BitStorageBlockEntity) {
            BitStorageBlockEntity storage = (BitStorageBlockEntity)targetedTileEntity;
            return storage.getState();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void drainPrimaryStorage(int amount) {
        Direction facing = (Direction)Objects.requireNonNull(this.func_145831_w()).func_180495_p(this.func_174877_v()).func_177229_b((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.func_176746_e();
        this.drainStorage(amount, targetedFacing);
    }

    public void drainSecondaryStorage(int amount) {
        Direction facing = (Direction)Objects.requireNonNull(this.func_145831_w()).func_180495_p(this.func_174877_v()).func_177229_b((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.func_176746_e().func_176746_e();
        this.drainStorage(amount, targetedFacing);
    }

    public void drainTertiaryStorage(int amount) {
        Direction facing = (Direction)Objects.requireNonNull(this.func_145831_w()).func_180495_p(this.func_174877_v()).func_177229_b((Property)ChiseledPrinterBlock.FACING);
        Direction targetedFacing = facing.func_176735_f();
        this.drainStorage(amount, targetedFacing);
    }

    private void drainStorage(int amount, Direction targetedFacing) {
        TileEntity targetedTileEntity = Objects.requireNonNull(this.func_145831_w()).func_175625_s(this.func_174877_v().func_177972_a(targetedFacing));
        if (targetedTileEntity instanceof BitStorageBlockEntity) {
            BitStorageBlockEntity storage = (BitStorageBlockEntity)targetedTileEntity;
            storage.extractBits(0, amount, false);
        }
    }

    public void dropInventoryItems(World worldIn, BlockPos pos) {
        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.getToolStack());
        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.getOutputStack());
        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.getPatternStack());
    }
}

