/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.watut.spritesets.SpriteSetPlayer;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class SpriteInfo {
    private final String name;
    private TextureAtlasSprite sprite;
    private SpriteSetPlayer spriteSetPlayer;

    public SpriteInfo(String name, int size, int tickDelay) {
        this.name = name;
        if (size > 0) {
            this.spriteSetPlayer = new SpriteSetPlayer(tickDelay, size);
        }
    }

    public boolean isSpriteSet() {
        return this.spriteSetPlayer != null;
    }

    public ResourceLocation getResLocationName() {
        return this.getResLocationName(0);
    }

    public ResourceLocation getResLocationName(int index) {
        if (this.isSpriteSet()) {
            return new ResourceLocation("watut:particles/" + this.name + index);
        }
        return new ResourceLocation("watut:particles/" + this.name);
    }

    public void textureAtlasPrepareToSitch(AtlasTexture textureAtlas, Set<ResourceLocation> sprites) {
        if (this.isSpriteSet()) {
            for (int i = 0; i < this.spriteSetPlayer.getFrames(); ++i) {
                sprites.add(this.getResLocationName(i));
            }
        } else {
            sprites.add(this.getResLocationName());
        }
    }

    public void setupSprites(AtlasTexture textureAtlas) {
        if (this.isSpriteSet()) {
            ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>();
            for (int i = 0; i < this.spriteSetPlayer.getFrames(); ++i) {
                TextureAtlasSprite textureAtlasSprite = textureAtlas.func_195424_a(this.getResLocationName(i));
                if (textureAtlasSprite != null) {
                    list.add(textureAtlasSprite);
                    continue;
                }
                System.out.println("failed to find " + this.getResLocationName(i));
            }
            this.spriteSetPlayer.setList(list);
            this.sprite = (TextureAtlasSprite)list.get(0);
        } else {
            this.sprite = textureAtlas.func_195424_a(this.getResLocationName());
            if (this.sprite == null) {
                System.out.println("failed to find " + this.getResLocationName());
            }
        }
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public String getName() {
        return this.name;
    }

    public SpriteSetPlayer getSpriteSet() {
        return this.spriteSetPlayer;
    }

    public void setSpriteSetPlayer(SpriteSetPlayer spriteSetPlayer) {
        this.spriteSetPlayer = spriteSetPlayer;
    }
}

