/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory.materials;

import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.AndMaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.OrMaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.SimpleMaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

abstract class SubMaterialListEntry
implements MaterialListEntry<SubMaterialListEntry> {
    private final ImmutableList<MaterialListEntry<?>> subEntries;
    private final ImmutableList<SimpleMaterialListEntry> constantEntries;
    private boolean simplified;

    public SubMaterialListEntry(ImmutableList<MaterialListEntry<?>> subEntries, ImmutableList<SimpleMaterialListEntry> simpleEntries, boolean simplified) {
        this.subEntries = Objects.requireNonNull(subEntries, "Cannot construct a SubMaterialListEntry without a list of Sub-MaterialEntries!");
        this.constantEntries = Objects.requireNonNull(simpleEntries, "Cannot construct a SubMaterialListEntry without a list of constant Entries!");
        this.simplified = simplified;
    }

    protected SubMaterialListEntry(ImmutableList<MaterialListEntry<?>> subEntries, ImmutableList<SimpleMaterialListEntry> simpleEntries) {
        this(subEntries, simpleEntries, false);
    }

    public SubMaterialListEntry(ImmutableList<MaterialListEntry<?>> subEntries) {
        this(subEntries, (ImmutableList<SimpleMaterialListEntry>)ImmutableList.of());
    }

    protected Stream<MaterialListEntry<?>> getAllSubEntries() {
        return Streams.concat((Stream[])new Stream[]{this.subEntries.stream(), this.constantEntries.stream()});
    }

    @Override
    public MaterialListEntry<?> simplify() {
        if (this.simplified) {
            return this;
        }
        ArrayList<OrMaterialListEntry> orEntries = new ArrayList<OrMaterialListEntry>(this.subEntries.size());
        ArrayList<AndMaterialListEntry> andEntries = new ArrayList<AndMaterialListEntry>(this.subEntries.size());
        ArrayList<SimpleMaterialListEntry> simpleEntries = new ArrayList<SimpleMaterialListEntry>((Collection<SimpleMaterialListEntry>)this.constantEntries);
        List<MaterialListEntry<?>> remainder = this.orderAndSimplifyEntries(orEntries, andEntries, simpleEntries);
        SimpleMaterialListEntry constantEntry = this.combine(simpleEntries);
        if (orEntries.isEmpty() && andEntries.isEmpty() && remainder.isEmpty()) {
            return constantEntry;
        }
        return this.createFrom(ImmutableList.builder().addAll(andEntries).addAll(orEntries).addAll(remainder).build(), (ImmutableList<SimpleMaterialListEntry>)(constantEntry.getItems().isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)constantEntry)), true);
    }

    protected abstract List<MaterialListEntry<?>> orderAndSimplifyEntries(List<OrMaterialListEntry> var1, List<AndMaterialListEntry> var2, List<SimpleMaterialListEntry> var3);

    protected ImmutableList<MaterialListEntry<?>> getSubEntries() {
        return this.subEntries;
    }

    protected ImmutableList<SimpleMaterialListEntry> getConstantEntries() {
        return this.constantEntries;
    }

    protected SimpleMaterialListEntry getCombinedConstantEntry() {
        return this.combine((List<SimpleMaterialListEntry>)this.constantEntries);
    }

    private SimpleMaterialListEntry combine(List<SimpleMaterialListEntry> simpleEntries) {
        if (simpleEntries.size() == 1) {
            return simpleEntries.get(0);
        }
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        for (SimpleMaterialListEntry entry : simpleEntries) {
            builder.addAll(entry.getItems());
        }
        return new SimpleMaterialListEntry(builder.build());
    }

    protected abstract SubMaterialListEntry createFrom(ImmutableList<MaterialListEntry<?>> var1, ImmutableList<SimpleMaterialListEntry> var2, boolean var3);

    protected Iterable<ImmutableMultiset<IUniqueObject<?>>> viewOnlySubEntries() {
        return this.createFrom(this.getSubEntries(), (ImmutableList<SimpleMaterialListEntry>)ImmutableList.of(), this.simplified);
    }

    protected void pullUpInnerEntries(SubMaterialListEntry entry, List<OrMaterialListEntry> orEntries, List<AndMaterialListEntry> andEntries, List<SimpleMaterialListEntry> simpleEntries, List<MaterialListEntry<?>> remainder) {
        for (MaterialListEntry subEntry : entry.getSubEntries()) {
            if (subEntry instanceof OrMaterialListEntry) {
                orEntries.add((OrMaterialListEntry)subEntry);
                continue;
            }
            if (subEntry instanceof AndMaterialListEntry) {
                andEntries.add((AndMaterialListEntry)subEntry);
                continue;
            }
            if (subEntry instanceof SimpleMaterialListEntry) {
                simpleEntries.add((SimpleMaterialListEntry)subEntry);
                continue;
            }
            remainder.add(subEntry);
        }
    }

    protected static abstract class Serializer
    implements MaterialListEntry.Serializer<SubMaterialListEntry> {
        private final ResourceLocation registryName;

        public Serializer(ResourceLocation registryName) {
            this.registryName = registryName;
        }

        @Override
        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        @Override
        public SubMaterialListEntry readFromNBT(CompoundNBT nbt, boolean persisted) {
            ListNBT list = nbt.func_150295_c("sub_entries", 10);
            ImmutableList.Builder entryBuilder = ImmutableList.builder();
            ImmutableList.Builder simpleBuilder = ImmutableList.builder();
            for (INBT subEntry : list) {
                MaterialListEntry<?> entry = MaterialList.readEntry((CompoundNBT)subEntry, persisted);
                if (entry instanceof SimpleMaterialListEntry) {
                    simpleBuilder.add((Object)((SimpleMaterialListEntry)entry));
                    continue;
                }
                entryBuilder.add(entry);
            }
            return this.create(entryBuilder.build(), (ImmutableList<SimpleMaterialListEntry>)simpleBuilder.build());
        }

        @Override
        public CompoundNBT writeToNBT(SubMaterialListEntry entry, boolean persisted) {
            ListNBT list = new ListNBT();
            entry.getAllSubEntries().map(subEntry -> MaterialList.writeEntry(subEntry, persisted)).forEach(arg_0 -> list.add(arg_0));
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("sub_entries", (INBT)list);
            return nbt;
        }

        @Override
        public JsonSerializer<SubMaterialListEntry> asJsonSerializer(boolean printName, boolean extended) {
            return (src, typeOfSrc, context) -> {
                JsonArray ar = new JsonArray();
                src.getAllSubEntries().forEach(entry -> {
                    JsonElement element = entry.getSerializer().asJsonSerializer(printName, extended).serialize(entry, entry.getClass(), context);
                    JsonObject obj = new JsonObject();
                    obj.add("entry_type", context.serialize((Object)entry.getSerializer().getRegistryName()));
                    if (element.isJsonArray()) {
                        obj.add("entries", (JsonElement)element.getAsJsonArray());
                    } else {
                        obj.add("entry", element);
                    }
                    ar.add((JsonElement)obj);
                });
                return ar;
            };
        }

        @Override
        public JsonDeserializer<SubMaterialListEntry> asJsonDeserializer() {
            return (json, typeOfT, context) -> {
                JsonArray array = json.getAsJsonArray();
                ImmutableList.Builder subEntries = ImmutableList.builder();
                for (JsonElement element : array) {
                    JsonObject object = element.getAsJsonObject();
                    ResourceLocation id = (ResourceLocation)context.deserialize(object.get("entry_type"), ResourceLocation.class);
                    MaterialListEntry.Serializer<?> serializer = MaterialList.getSerializerForId(id);
                    if (serializer == null) continue;
                    JsonElement subEntry = object.has("entries") ? object.get("entries") : object.get("entry");
                    subEntries.add(serializer.asJsonDeserializer().deserialize(subEntry, MaterialListEntry.class, context));
                }
                MaterialListEntry<?> entry = this.create(subEntries.build(), (ImmutableList<SimpleMaterialListEntry>)ImmutableList.of()).simplify();
                if (entry instanceof SubMaterialListEntry) {
                    return (SubMaterialListEntry)entry;
                }
                return new AndMaterialListEntry(ImmutableList.of(entry));
            };
        }

        protected abstract SubMaterialListEntry create(ImmutableList<MaterialListEntry<?>> var1, ImmutableList<SimpleMaterialListEntry> var2);
    }
}

