/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderExperience;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiSlider;
import exopandora.worldhandler.gui.widget.button.LogicSliderSimple;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentExperience
extends Content {
    private final BuilderExperience builderExperience = new BuilderExperience();
    private GuiButtonBase buttonAdd;
    private GuiButtonBase buttonRemove;

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderExperience;
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderExperience.getLevel() > Config.getSliders().getMaxExperience()) {
            this.builderExperience.setLevel((int)Config.getSliders().getMaxExperience());
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        boolean enabled;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        container.add(new GuiSlider(x + 58, y, 114, 20, 0.0, Config.getSliders().getMaxExperience(), 0.0, container, new LogicSliderSimple("experience", (IFormattableTextComponent)new TranslationTextComponent("gui.worldhandler.title.player.experience"), value -> this.builderExperience.setLevel((int)value))));
        this.buttonAdd = new GuiButtonBase(x + 58, y + 24, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.add"), () -> {
            CommandHelper.sendCommand(container.getPlayer(), this.builderExperience.buildAdd());
            container.func_231160_c_();
        });
        container.add(this.buttonAdd);
        this.buttonRemove = new GuiButtonBase(x + 58, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.remove"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderExperience.buildRemove()));
        container.add(this.buttonRemove);
        container.add(new GuiButtonTooltip(x + 58, y + 72, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.reset"), (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.set_to_0"), () -> {
            CommandHelper.sendCommand(container.getPlayer(), this.builderExperience.buildReset());
            container.func_231160_c_();
        }));
        this.buttonAdd.field_230693_o_ = enabled = this.builderExperience.getLevel() > 0;
        this.buttonRemove.field_230693_o_ = enabled;
    }

    @Override
    public void tick(Container container) {
        boolean enabled;
        this.buttonAdd.field_230693_o_ = enabled = this.builderExperience.getLevel() > 0;
        this.buttonRemove.field_230693_o_ = enabled;
    }

    @Override
    public Category getCategory() {
        return Categories.PLAYER;
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.player.experience");
    }

    @Override
    public IFormattableTextComponent getTabTitle() {
        return new TranslationTextComponent("gui.worldhandler.tab.player.experience");
    }

    @Override
    public Content getActiveContent() {
        return Contents.EXPERIENCE;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderExperience.setPlayer(username);
    }
}

