/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.gui.DummyScreen;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.IConnection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.MultiplayerWarningScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.realms.RealmsBridgeScreen;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentChangeWorld
extends ContentChild {
    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        container.add(new GuiButtonBase(x + 58, y + 24, 116, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.change_world.singleplayer"), () -> {
            IConnection connection = ContentChangeWorld.disconnect();
            Minecraft.func_71410_x().func_147108_a((Screen)new WorldSelectionScreen((Screen)new DummyScreen(() -> ContentChangeWorld.reconnect(connection))));
        }));
        container.add(new GuiButtonBase(x + 58, y + 48, 116, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.change_world.multiplayer"), () -> {
            IConnection connection = ContentChangeWorld.disconnect();
            DummyScreen dummy = new DummyScreen(() -> ContentChangeWorld.reconnect(connection));
            if (Minecraft.func_71410_x().field_71474_y.field_230152_Z_) {
                Minecraft.func_71410_x().func_147108_a((Screen)new MultiplayerScreen((Screen)dummy));
            } else {
                Minecraft.func_71410_x().func_147108_a((Screen)new MultiplayerWarningScreen((Screen)dummy));
            }
        }));
    }

    private static IConnection disconnect() {
        boolean isIntegrated = Minecraft.func_71410_x().func_71387_A();
        boolean isRealms = Minecraft.func_71410_x().func_181540_al();
        ServerData data = Minecraft.func_71410_x().func_147104_D();
        if (isIntegrated) {
            IntegratedServer integrated = Minecraft.func_71410_x().func_71401_C();
            String folder = integrated.field_71310_m.func_237282_a_();
            DimensionGeneratorSettings dimensionGeneratorSettings = integrated.func_240793_aU_().func_230418_z_();
            WorldSettings worldSettings = integrated.func_240793_aU_().func_230408_H_();
            Minecraft.func_71410_x().field_71441_e.func_72882_A();
            Minecraft.func_71410_x().func_213231_b((Screen)new DirtMessageScreen((ITextComponent)new TranslationTextComponent("menu.savingLevel")));
            return new IConnection.IntegratedConnection(folder, worldSettings, dimensionGeneratorSettings);
        }
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Minecraft.func_71410_x().field_71441_e.func_72882_A();
            Minecraft.func_71410_x().func_213254_o();
        }
        if (isRealms) {
            return null;
        }
        return new IConnection.DedicatedConnection(data);
    }

    private static void reconnect(IConnection connection) {
        if (connection == null) {
            RealmsBridgeScreen realmsbridge = new RealmsBridgeScreen();
            realmsbridge.func_231394_a_((Screen)new MainMenuScreen());
        } else if (connection instanceof IConnection.IntegratedConnection) {
            IConnection.IntegratedConnection integrated = (IConnection.IntegratedConnection)connection;
            Minecraft.func_71410_x().func_238192_a_(integrated.getFolder(), integrated.getWorldSettings(), DynamicRegistries.func_239770_b_(), integrated.getDimensionGeneratorSettings());
            Minecraft.func_71410_x().field_71417_B.func_198034_i();
        } else if (connection instanceof IConnection.DedicatedConnection) {
            IConnection.DedicatedConnection dedicated = (IConnection.DedicatedConnection)connection;
            Minecraft.func_71410_x().func_147108_a((Screen)new ConnectingScreen((Screen)new MainMenuScreen(), Minecraft.func_71410_x(), dedicated.getData()));
            Minecraft.func_71410_x().field_71417_B.func_198034_i();
        }
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.change_world");
    }
}

