/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.pathfinding.raycoms.Node;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncPath {
    public Set<Node> lastDebugNodesVisited = new HashSet<Node>();
    public Set<Node> lastDebugNodesNotVisited = new HashSet<Node>();
    public Set<Node> lastDebugNodesPath = new HashSet<Node>();

    public MessageSyncPath(Set<Node> lastDebugNodesVisited, Set<Node> lastDebugNodesNotVisited, Set<Node> lastDebugNodesPath) {
        this.lastDebugNodesVisited = lastDebugNodesVisited;
        this.lastDebugNodesNotVisited = lastDebugNodesNotVisited;
        this.lastDebugNodesPath = lastDebugNodesPath;
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(this.lastDebugNodesVisited.size());
        for (Node node : this.lastDebugNodesVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesNotVisited.size());
        for (Node node : this.lastDebugNodesNotVisited) {
            node.serializeToBuf(buf);
        }
        buf.writeInt(this.lastDebugNodesPath.size());
        for (Node node : this.lastDebugNodesPath) {
            node.serializeToBuf(buf);
        }
    }

    public static MessageSyncPath read(PacketBuffer buf) {
        int size = buf.readInt();
        HashSet<Node> lastDebugNodesVisited = new HashSet<Node>();
        for (int i = 0; i < size; ++i) {
            lastDebugNodesVisited.add(new Node(buf));
        }
        size = buf.readInt();
        HashSet<Node> lastDebugNodesNotVisited = new HashSet<Node>();
        for (int i = 0; i < size; ++i) {
            lastDebugNodesNotVisited.add(new Node(buf));
        }
        size = buf.readInt();
        HashSet<Node> lastDebugNodesPath = new HashSet<Node>();
        for (int i = 0; i < size; ++i) {
            lastDebugNodesPath.add(new Node(buf));
        }
        return new MessageSyncPath(lastDebugNodesVisited, lastDebugNodesNotVisited, lastDebugNodesPath);
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Pathfinding.lastDebugNodesVisited = this.lastDebugNodesVisited;
                Pathfinding.lastDebugNodesNotVisited = this.lastDebugNodesNotVisited;
                Pathfinding.lastDebugNodesPath = this.lastDebugNodesPath;
            }
        });
        return true;
    }

    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }
}

