/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.energy;

import appeng.api.networking.energy.IEnergyWatcher;
import appeng.api.networking.energy.IEnergyWatcherHost;
import appeng.me.cache.EnergyGridCache;
import appeng.me.energy.EnergyThreshold;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EnergyWatcher
implements IEnergyWatcher {
    private final EnergyGridCache gsc;
    private final IEnergyWatcherHost watcherHost;
    private final Set<EnergyThreshold> myInterests = new HashSet<EnergyThreshold>();

    public EnergyWatcher(EnergyGridCache cache, IEnergyWatcherHost host) {
        this.gsc = cache;
        this.watcherHost = host;
    }

    public void post(EnergyGridCache energyGridCache) {
        this.watcherHost.onThresholdPass(energyGridCache);
    }

    public IEnergyWatcherHost getHost() {
        return this.watcherHost;
    }

    @Override
    public boolean add(double amount) {
        EnergyThreshold eh = new EnergyThreshold(amount, this);
        if (this.myInterests.contains(eh)) {
            return false;
        }
        return this.gsc.registerEnergyInterest(eh) && this.myInterests.add(eh);
    }

    @Override
    public boolean remove(double amount) {
        EnergyThreshold eh = new EnergyThreshold(amount, this);
        return this.myInterests.remove(eh) && this.gsc.unregisterEnergyInterest(eh);
    }

    @Override
    public void reset() {
        Iterator<EnergyThreshold> iterator = this.myInterests.iterator();
        while (iterator.hasNext()) {
            EnergyThreshold threshold = iterator.next();
            this.gsc.unregisterEnergyInterest(threshold);
            iterator.remove();
        }
    }
}

