/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalWaterloggedBlock;
import com.mrcrayfish.furniture.entity.SeatEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ParkBenchBlock
extends FurnitureHorizontalWaterloggedBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.func_177709_a((String)"type", Type.class);
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ParkBenchBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH)).func_206870_a(TYPE, (Comparable)((Object)Type.SINGLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] SEAT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)8.0, (double)3.0, (double)16.0, (double)9.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] BACKREST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)9.0, (double)1.0, (double)16.0, (double)20.0, (double)5.0), Direction.SOUTH));
        VoxelShape[] BACK_LEFT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)0.0, (double)3.0, (double)4.0, (double)8.0, (double)6.0), Direction.SOUTH));
        VoxelShape[] FRONT_LEFT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] FRONT_RIGHT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] BACK_RIGHT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)12.0, (double)0.0, (double)3.0, (double)15.0, (double)8.0, (double)6.0), Direction.SOUTH));
        VoxelShape[] LEFT_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)6.0, (double)6.0, (double)4.0, (double)8.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] RIGHT_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)12.0, (double)6.0, (double)6.0, (double)15.0, (double)8.0, (double)12.0), Direction.SOUTH));
        VoxelShape[] FRONT_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)6.0, (double)12.0, (double)15.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] BACK_SUPPORT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)6.0, (double)3.0, (double)15.0, (double)8.0, (double)6.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
            Type type = (Type)((Object)state.func_177229_b(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(SEAT[direction.func_176736_b()]);
            shapes.add(BACKREST[direction.func_176736_b()]);
            shapes.add(FRONT_SUPPORT[direction.func_176736_b()]);
            shapes.add(BACK_SUPPORT[direction.func_176736_b()]);
            switch (type) {
                case SINGLE: {
                    shapes.add(BACK_LEFT_LEG[direction.func_176736_b()]);
                    shapes.add(FRONT_LEFT_LEG[direction.func_176736_b()]);
                    shapes.add(FRONT_RIGHT_LEG[direction.func_176736_b()]);
                    shapes.add(BACK_RIGHT_LEG[direction.func_176736_b()]);
                    shapes.add(LEFT_SUPPORT[direction.func_176736_b()]);
                    shapes.add(RIGHT_SUPPORT[direction.func_176736_b()]);
                    break;
                }
                case LEFT: {
                    shapes.add(BACK_LEFT_LEG[direction.func_176736_b()]);
                    shapes.add(FRONT_LEFT_LEG[direction.func_176736_b()]);
                    shapes.add(LEFT_SUPPORT[direction.func_176736_b()]);
                    break;
                }
                case RIGHT: {
                    shapes.add(FRONT_RIGHT_LEG[direction.func_176736_b()]);
                    shapes.add(BACK_RIGHT_LEG[direction.func_176736_b()]);
                    shapes.add(RIGHT_SUPPORT[direction.func_176736_b()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        return SeatEntity.create(world, pos, 0.3375, playerEntity);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return this.getBenchState(state, (IWorld)context.func_195991_k(), context.func_195995_a(), (Direction)state.func_177229_b((Property)DIRECTION));
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        return this.getBenchState(state, world, pos, (Direction)state.func_177229_b((Property)DIRECTION));
    }

    private BlockState getBenchState(BlockState state, IWorld world, BlockPos pos, Direction dir) {
        boolean left = this.isBench(world, pos, dir.func_176735_f(), dir);
        boolean right = this.isBench(world, pos, dir.func_176746_e(), dir);
        if (left && right) {
            return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (left) {
            return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.RIGHT));
        }
        if (right) {
            return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.LEFT));
        }
        return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    private boolean isBench(IWorld world, BlockPos source, Direction direction, Direction targetDirection) {
        BlockState state = world.func_180495_p(source.func_177972_a(direction));
        if (state.func_177230_c() == this) {
            Direction sofaDirection = (Direction)state.func_177229_b((Property)DIRECTION);
            return sofaDirection.equals((Object)targetDirection);
        }
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TYPE});
    }

    public static enum Type implements IStringSerializable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String func_176610_l() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

