/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renders;

import com.direwolf20.buildinggadgets.client.renderer.DireBufferBuilder;
import com.direwolf20.buildinggadgets.client.renderer.DireVertexBuffer;
import com.direwolf20.buildinggadgets.client.renderer.MyRenderMethods;
import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.world.MockDelegationWorld;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class CopyPasteRender
extends BaseRenderer
implements ITemplateProvider.IUpdateListener {
    private MultiVBORenderer renderBuffer;
    private int tickTrack = 0;
    private UUID lastRendered = null;

    @Override
    public void onTemplateUpdate(ITemplateProvider provider, ITemplateKey key, Template template) {
        if (provider.getId(key).equals(this.lastRendered)) {
            this.renderBuffer = null;
        }
    }

    @Override
    public void onTemplateUpdateSend(ITemplateProvider provider, ITemplateKey key, Template template) {
        this.onTemplateUpdate(provider, key, template);
    }

    @Override
    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        super.render(evt, player, heldItem);
        Vector3d cameraView = CopyPasteRender.getMc().field_71460_t.func_215316_n().func_216785_c();
        MatrixStack stack = evt.getMatrixStack();
        stack.func_227860_a_();
        stack.func_227861_a_(-cameraView.func_82615_a(), -cameraView.func_82617_b(), -cameraView.func_82616_c());
        if (GadgetCopyPaste.getToolMode(heldItem) == GadgetCopyPaste.ToolMode.COPY) {
            this.renderBuffer = null;
            GadgetCopyPaste.getSelectedRegion(heldItem).ifPresent(region -> this.renderCopy(stack, (Region)region));
        } else {
            this.renderPaste(stack, cameraView, player, heldItem);
        }
        stack.func_227865_b_();
    }

    private void renderCopy(MatrixStack matrix, Region region) {
        BlockPos startPos = region.getMin();
        BlockPos endPos = region.getMax();
        BlockPos blankPos = new BlockPos(0, 0, 0);
        if (startPos.equals((Object)blankPos) || endPos.equals((Object)blankPos)) {
            return;
        }
        int x = Math.min(startPos.func_177958_n(), endPos.func_177958_n());
        int y = Math.min(startPos.func_177956_o(), endPos.func_177956_o());
        int z = Math.min(startPos.func_177952_p(), endPos.func_177952_p());
        int dx = startPos.func_177958_n() > endPos.func_177958_n() ? startPos.func_177958_n() + 1 : endPos.func_177958_n() + 1;
        int dy = startPos.func_177956_o() > endPos.func_177956_o() ? startPos.func_177956_o() + 1 : endPos.func_177956_o() + 1;
        int dz = startPos.func_177952_p() > endPos.func_177952_p() ? startPos.func_177952_p() + 1 : endPos.func_177952_p() + 1;
        int R = 255;
        int G = 223;
        int B = 127;
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(OurRenderTypes.CopyGadgetLines);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(matrix4f, (float)x, (float)y, (float)z).func_227885_a_((float)G, (float)G, (float)G, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)x, (float)y, (float)z).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)dx, (float)y, (float)z).func_225586_a_(G, B, B, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)dx, (float)y, (float)dz).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)x, (float)y, (float)dz).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)x, (float)y, (float)z).func_225586_a_(B, B, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)x, (float)dy, (float)z).func_225586_a_(B, G, B, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)dx, (float)dy, (float)z).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)dx, (float)dy, (float)dz).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)x, (float)dy, (float)dz).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)x, (float)dy, (float)z).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)x, (float)dy, (float)dz).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)x, (float)y, (float)dz).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)dx, (float)y, (float)dz).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)dx, (float)dy, (float)dz).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)dx, (float)dy, (float)z).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)dx, (float)y, (float)z).func_225586_a_(G, G, G, R).func_181675_d();
        builder.func_227888_a_(matrix4f, (float)dx, (float)y, (float)z).func_227885_a_((float)G, (float)G, (float)G, 0.0f).func_181675_d();
        buffer.func_228461_a_();
    }

    private void renderPaste(MatrixStack matrices, Vector3d cameraView, PlayerEntity player, ItemStack heldItem) {
        World world = player.field_70170_p;
        world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> heldItem.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(key -> GadgetCopyPaste.getActivePos(player, heldItem).ifPresent(startPos -> {
            MockDelegationWorld fakeWorld = new MockDelegationWorld((IWorld)world);
            BuildContext context = BuildContext.builder().player(player).stack(heldItem).build(fakeWorld);
            IBuildView view = provider.getTemplateForKey((ITemplateKey)key).createViewInContext(context);
            ArrayList<PlacementTarget> targets = new ArrayList<PlacementTarget>(view.estimateSize());
            for (PlacementTarget target : view) {
                if (!target.placeIn(context)) continue;
                targets.add(target);
            }
            UUID id = provider.getId((ITemplateKey)key);
            if (!id.equals(this.lastRendered)) {
                this.renderBuffer = null;
            }
            this.renderTargets(matrices, cameraView, context, (List<PlacementTarget>)targets, (BlockPos)startPos);
            this.lastRendered = id;
        })));
    }

    private void renderTargets(MatrixStack matrix, Vector3d projectedView, BuildContext context, List<PlacementTarget> targets, BlockPos startPos) {
        ++this.tickTrack;
        if (this.renderBuffer != null && this.tickTrack < 300) {
            if (this.tickTrack % 30 == 0) {
                try {
                    Vector3d projectedView2 = projectedView;
                    Vector3d startPosView = new Vector3d((double)startPos.func_177958_n(), (double)startPos.func_177956_o(), (double)startPos.func_177952_p());
                    projectedView2 = projectedView2.func_178788_d(startPosView);
                    this.renderBuffer.sort((float)projectedView2.func_82615_a(), (float)projectedView2.func_82617_b(), (float)projectedView2.func_82616_c());
                }
                catch (Exception projectedView2) {
                    // empty catch block
                }
            }
            matrix.func_227861_a_((double)startPos.func_177958_n(), (double)startPos.func_177956_o(), (double)startPos.func_177952_p());
            this.renderBuffer.render(matrix.func_227866_c_().func_227870_a_());
            return;
        }
        this.tickTrack = 0;
        if (this.renderBuffer != null) {
            this.renderBuffer.close();
        }
        this.renderBuffer = MultiVBORenderer.of(buffer -> {
            IVertexBuilder builder = buffer.getBuffer(OurRenderTypes.RenderBlock);
            IVertexBuilder noDepthbuilder = buffer.getBuffer(OurRenderTypes.CopyPasteRenderBlock);
            BlockRendererDispatcher dispatcher = CopyPasteRender.getMc().func_175602_ab();
            MatrixStack stack = new MatrixStack();
            stack.func_227860_a_();
            for (PlacementTarget target : targets) {
                BlockPos targetPos = target.getPos();
                BlockState state = context.getWorld().func_180495_p(target.getPos());
                stack.func_227860_a_();
                stack.func_227861_a_((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p());
                IBakedModel ibakedmodel = dispatcher.func_184389_a(state);
                BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
                int color = blockColors.func_228054_a_(state, (IBlockDisplayReader)context.getWorld(), targetPos, 0);
                float f = (float)(color >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(color & 0xFF) / 255.0f;
                try {
                    if (state.func_185901_i() == BlockRenderType.MODEL) {
                        for (Direction direction : Direction.values()) {
                            if (!Block.func_176225_a((BlockState)state, (IBlockReader)context.getWorld(), (BlockPos)targetPos, (Direction)direction) || context.getWorld().func_180495_p(targetPos.func_177972_a(direction)).func_177230_c().equals(state.func_177230_c())) continue;
                            if (state.func_185904_a().func_76218_k()) {
                                MyRenderMethods.renderModelBrightnessColorQuads(stack.func_227866_c_(), builder, f, f1, f2, 0.7f, ibakedmodel.getQuads(state, direction, new Random(MathHelper.func_180186_a((Vector3i)targetPos)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
                                continue;
                            }
                            MyRenderMethods.renderModelBrightnessColorQuads(stack.func_227866_c_(), noDepthbuilder, f, f1, f2, 0.7f, ibakedmodel.getQuads(state, direction, new Random(MathHelper.func_180186_a((Vector3i)targetPos)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
                        }
                        if (state.func_185904_a().func_76218_k()) {
                            MyRenderMethods.renderModelBrightnessColorQuads(stack.func_227866_c_(), builder, f, f1, f2, 0.7f, ibakedmodel.getQuads(state, null, new Random(MathHelper.func_180186_a((Vector3i)targetPos)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
                        } else {
                            MyRenderMethods.renderModelBrightnessColorQuads(stack.func_227866_c_(), noDepthbuilder, f, f1, f2, 0.7f, ibakedmodel.getQuads(state, null, new Random(MathHelper.func_180186_a((Vector3i)targetPos)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
                        }
                    }
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.trace("Caught exception whilst rendering {}.", (Object)state, (Object)e);
                }
                stack.func_227865_b_();
            }
            stack.func_227865_b_();
        });
        Vector3d projectedView2 = CopyPasteRender.getMc().field_71460_t.func_215316_n().func_216785_c();
        Vector3d startPosView = new Vector3d((double)startPos.func_177958_n(), (double)startPos.func_177956_o(), (double)startPos.func_177952_p());
        projectedView2 = projectedView2.func_178788_d(startPosView);
        this.renderBuffer.sort((float)projectedView2.func_82615_a(), (float)projectedView2.func_82617_b(), (float)projectedView2.func_82616_c());
        matrix.func_227861_a_((double)startPos.func_177958_n(), (double)startPos.func_177956_o(), (double)startPos.func_177952_p());
        this.renderBuffer.render(matrix.func_227866_c_().func_227870_a_());
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    public static class MultiVBORenderer
    implements Closeable {
        private static final int BUFFER_SIZE = 0x600000;
        private final ImmutableMap<RenderType, DireVertexBuffer> buffers;
        private final ImmutableMap<RenderType, DireBufferBuilder.State> sortCaches;

        public static MultiVBORenderer of(Consumer<IRenderTypeBuffer> vertexProducer) {
            HashMap builders = Maps.newHashMap();
            vertexProducer.accept(rt -> builders.computeIfAbsent(rt, _rt -> {
                DireBufferBuilder builder = new DireBufferBuilder(0x600000);
                builder.begin(_rt.func_228664_q_(), _rt.func_228663_p_());
                return builder;
            }));
            HashMap sortCaches = Maps.newHashMap();
            Map buffers = Maps.transformEntries((Map)builders, (rt, builder) -> {
                Objects.requireNonNull(rt);
                Objects.requireNonNull(builder);
                sortCaches.put(rt, builder.getVertexState());
                builder.finishDrawing();
                VertexFormat fmt = rt.func_228663_p_();
                DireVertexBuffer vbo = new DireVertexBuffer(fmt);
                vbo.upload((DireBufferBuilder)((Object)builder));
                return vbo;
            });
            return new MultiVBORenderer(buffers, sortCaches);
        }

        protected MultiVBORenderer(Map<RenderType, DireVertexBuffer> buffers, Map<RenderType, DireBufferBuilder.State> sortCaches) {
            this.buffers = ImmutableMap.copyOf(buffers);
            this.sortCaches = ImmutableMap.copyOf(sortCaches);
        }

        public void sort(float x, float y, float z) {
            for (Map.Entry kv : this.sortCaches.entrySet()) {
                RenderType rt = (RenderType)kv.getKey();
                DireBufferBuilder.State state = (DireBufferBuilder.State)kv.getValue();
                DireBufferBuilder builder = new DireBufferBuilder(0x600000);
                builder.begin(rt.func_228664_q_(), rt.func_228663_p_());
                builder.setVertexState(state);
                builder.sortVertexData(x, y, z);
                builder.finishDrawing();
                DireVertexBuffer vbo = (DireVertexBuffer)this.buffers.get((Object)rt);
                vbo.upload(builder);
            }
        }

        public void render(Matrix4f matrix) {
            this.buffers.forEach((rt, vbo) -> {
                VertexFormat fmt = rt.func_228663_p_();
                rt.func_228547_a_();
                vbo.bindBuffer();
                fmt.func_227892_a_(0L);
                vbo.draw(matrix, rt.func_228664_q_());
                DireVertexBuffer.unbindBuffer();
                fmt.func_227895_d_();
                rt.func_228549_b_();
            });
        }

        @Override
        public void close() {
            this.buffers.values().forEach(DireVertexBuffer::close);
        }
    }
}

