/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.sound;

import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.sound.ContinuousSound;
import com.simibubi.create.foundation.sound.RepeatingSound;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

class SoundScape {
    List<ContinuousSound> continuous;
    List<RepeatingSound> repeating;
    private float pitch;
    private SoundScapes.AmbienceGroup group;
    private Vector3d meanPos;
    private SoundScapes.PitchGroup pitchGroup;

    public SoundScape(float pitch, SoundScapes.AmbienceGroup group) {
        this.pitchGroup = SoundScapes.getGroupFromPitch(pitch);
        this.pitch = pitch;
        this.group = group;
        this.continuous = new ArrayList<ContinuousSound>();
        this.repeating = new ArrayList<RepeatingSound>();
    }

    public SoundScape continuous(SoundEvent sound, float relativeVolume, float relativePitch) {
        return this.add(new ContinuousSound(sound, this, this.pitch * relativePitch, relativeVolume));
    }

    public SoundScape repeating(SoundEvent sound, float relativeVolume, float relativePitch, int delay) {
        return this.add(new RepeatingSound(sound, this, this.pitch * relativePitch, relativeVolume, delay));
    }

    public SoundScape add(ContinuousSound continuousSound) {
        this.continuous.add(continuousSound);
        return this;
    }

    public SoundScape add(RepeatingSound repeatingSound) {
        this.repeating.add(repeatingSound);
        return this;
    }

    public void play() {
        this.continuous.forEach(arg_0 -> ((SoundHandler)Minecraft.func_71410_x().func_147118_V()).func_147682_a(arg_0));
    }

    public void tick() {
        if (AnimationTickHolder.getTicks() % 5 == 0) {
            this.meanPos = null;
        }
        this.repeating.forEach(RepeatingSound::tick);
    }

    public void remove() {
        this.continuous.forEach(ContinuousSound::remove);
    }

    public Vector3d getMeanPos() {
        return this.meanPos == null ? (this.meanPos = this.determineMeanPos()) : this.meanPos;
    }

    private Vector3d determineMeanPos() {
        this.meanPos = Vector3d.field_186680_a;
        int amount = 0;
        for (BlockPos blockPos : SoundScapes.getAllLocations(this.group, this.pitchGroup)) {
            this.meanPos = this.meanPos.func_178787_e(VecHelper.getCenterOf((Vector3i)blockPos));
            ++amount;
        }
        if (amount == 0) {
            return this.meanPos;
        }
        return this.meanPos.func_186678_a((double)(1.0f / (float)amount));
    }

    public float getVolume() {
        Entity renderViewEntity = Minecraft.func_71410_x().field_175622_Z;
        float distanceMultiplier = 0.0f;
        if (renderViewEntity != null) {
            double distanceTo = renderViewEntity.func_213303_ch().func_72438_d(this.getMeanPos());
            distanceMultiplier = (float)MathHelper.func_219803_d((double)(distanceTo / 16.0), (double)2.0, (double)0.0);
        }
        int soundCount = SoundScapes.getSoundCount(this.group, this.pitchGroup);
        float max = AllConfigs.CLIENT.ambientVolumeCap.getF();
        float argMax = 15.0f;
        return MathHelper.func_76131_a((float)((float)soundCount / (argMax * 10.0f)), (float)0.025f, (float)max) * distanceMultiplier;
    }
}

