/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.widget.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.util.ILogic;
import exopandora.worldhandler.util.RenderUtils;
import exopandora.worldhandler.util.TextUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiSlider
extends GuiButtonBase {
    private final Persistence persistence;
    private final ILogicSlider logic;
    private final Container container;

    public GuiSlider(int x, int y, int widthIn, int heightIn, double min, double max, double start, Container container, ILogicSlider logic) {
        super(x, y, widthIn, heightIn, StringTextComponent.field_240750_d_, null);
        this.logic = Objects.requireNonNull(logic);
        this.container = Objects.requireNonNull(container);
        this.persistence = this.container.getContent().getPersistence(this.logic.getId(), () -> new Persistence(min, max, min == max ? 0.0 : (start - min) / (max - min)));
        this.persistence.validate(min, max);
        this.logic.onChangeSliderValue(this.persistence.getValueInt());
        this.updateDisplayString();
    }

    @Override
    protected void func_230441_a_(MatrixStack matrix, Minecraft minecraft, int mouseX, int mouseY) {
        super.func_230441_a_(matrix, minecraft, mouseX, mouseY);
        int hovered = super.func_230989_a_(this.func_230449_g_());
        int textureOffset = (Config.getSkin().getTextureType().equals("resourcepack") ? 46 : 0) + hovered * 20;
        RenderSystem.enableBlend();
        RenderUtils.colorDefaultButton();
        this.func_238474_b_(matrix, this.field_230690_l_ + (int)(this.persistence.getValue() * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, textureOffset, 4, 20);
        this.func_238474_b_(matrix, this.field_230690_l_ + (int)(this.persistence.getValue() * (double)(this.field_230688_j_ - 8)) + 4, this.field_230691_m_, 196, textureOffset, 4, 20);
        RenderSystem.disableBlend();
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.updateSlider(mouseX);
    }

    protected void func_230983_a_(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.updateSlider(mouseX);
        super.func_230983_a_(mouseX, mouseY, deltaX, deltaY);
    }

    protected void updateSlider(double mouseX) {
        this.persistence.setValue((mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8));
        if (this.persistence.getValue() < 0.0) {
            this.persistence.setValue(0.0);
        }
        if (this.persistence.getValue() > 1.0) {
            this.persistence.setValue(1.0);
        }
        this.updateDisplayString();
        this.logic.onChangeSliderValue(this.persistence.getValueInt());
    }

    protected int func_230989_a_(boolean mouseOver) {
        return 0;
    }

    private void updateDisplayString() {
        int value = this.persistence.getValueInt();
        IFormattableTextComponent suffix = this.logic.formatValue(value).func_230529_a_((ITextComponent)this.logic.formatSuffix(value));
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        IFormattableTextComponent text = TextUtils.stripText(this.logic.formatPrefix(value), this.field_230688_j_ - fontRenderer.func_238414_a_((ITextProperties)suffix), fontRenderer).func_230529_a_((ITextComponent)suffix);
        this.func_238482_a_((ITextComponent)text);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Persistence {
        private double min;
        private double max;
        private double value;

        private Persistence(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public Persistence(double min, double max, double value) {
            this(min, max);
            this.value = value;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public int getValueInt() {
            return (int)Math.round(this.min + (this.max - this.min) * this.value);
        }

        public void setValueInt(int value) {
            this.value = this.intToValue(value);
        }

        public void validate(double min, double max) {
            if (this.getMin() != min || this.getMax() != max) {
                this.min = min;
                this.max = max;
            }
        }

        private double intToValue(int value) {
            if (this.min == this.max) {
                return 0.0;
            }
            return ((double)value - this.min) / (this.max - this.min);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface ILogicSlider
    extends ILogic {
        public IFormattableTextComponent formatPrefix(int var1);

        public IFormattableTextComponent formatSuffix(int var1);

        public IFormattableTextComponent formatValue(int var1);

        public void onChangeSliderValue(int var1);
    }
}

