/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderMultiCommand;
import exopandora.worldhandler.builder.impl.BuilderPotionEffect;
import exopandora.worldhandler.builder.impl.BuilderPotionItem;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.impl.ContentChild;
import exopandora.worldhandler.gui.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.menu.impl.MenuPageList;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.widget.button.GuiSlider;
import exopandora.worldhandler.gui.widget.button.LogicSliderSimple;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.CommandHelper;
import exopandora.worldhandler.util.TextUtils;
import java.util.ArrayList;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ContentPotions
extends ContentChild {
    private int potionPage;
    private final BuilderPotionEffect builderPotion = new BuilderPotionEffect();
    private final BuilderPotionItem builderPotionItem = new BuilderPotionItem();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return new BuilderMultiCommand(this.builderPotion, this.builderPotionItem);
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderPotion.getAmplifier() > Config.getSliders().getMaxPotionAmplifier()) {
            this.builderPotion.setAmplifier((byte)Config.getSliders().getMaxPotionAmplifier());
        }
        for (Effect potion : this.builderPotionItem.getEffects()) {
            byte amplifier = this.builderPotionItem.getAmplifier(potion);
            if (!((double)amplifier > Config.getSliders().getMaxPotionAmplifier())) continue;
            this.builderPotionItem.setAmplifier(potion, (byte)Config.getSliders().getMaxPotionAmplifier());
        }
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        MenuPageList<Effect> potions = new MenuPageList<Effect>(x, y, new ArrayList(ForgeRegistries.POTIONS.getValues()), 114, 20, 3, container, new ILogicPageList<Effect>(){

            @Override
            public IFormattableTextComponent translate(Effect item) {
                return new TranslationTextComponent(item.func_76393_a());
            }

            @Override
            public IFormattableTextComponent toTooltip(Effect item) {
                return new StringTextComponent(item.getRegistryName().toString());
            }

            @Override
            public void onClick(Effect item) {
                ContentPotions.this.builderPotion.setEffect(item);
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, IFormattableTextComponent text, Effect item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, (ITextComponent)text, (ITextComponent)this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "potions";
            }
        });
        container.add(potions);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        GuiButtonBase button1;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        if (this.potionPage == 0) {
            container.add(new GuiButtonBase(x + 118, y + 12, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.give"), () -> this.next(container)));
            container.add(new GuiButtonBase(x + 118, y + 36, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.remove"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotion.buildRemove());
                container.func_231160_c_();
            }));
            container.add(new GuiButtonBase(x + 118, y + 60, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.remove_all"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotion.buildClear());
                container.func_231160_c_();
            }));
        } else if (this.potionPage == 1) {
            Effect potion = this.builderPotion.getEffectAsPotion();
            container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.ambient", new Object[]{this.builderPotionItem.getAmbient(potion) ? new TranslationTextComponent("gui.worldhandler.generic.on") : new TranslationTextComponent("gui.worldhandler.generic.off")}), () -> {
                this.builderPotionItem.setAmbient(potion, !this.builderPotionItem.getAmbient(potion));
                container.func_231160_c_();
            }));
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.particles", new Object[]{this.builderPotion.getHideParticles() ? new TranslationTextComponent("gui.worldhandler.generic.off") : new TranslationTextComponent("gui.worldhandler.generic.on")}), () -> {
                this.builderPotion.setHideParticles(!this.builderPotion.getHideParticles());
                this.builderPotionItem.setShowParticles(potion, !this.builderPotionItem.getShowParticles(potion));
                container.func_231160_c_();
            }));
            container.add(new GuiSlider(x + 118, y, 114, 20, 0.0, Config.getSliders().getMaxPotionAmplifier(), 0.0, container, new LogicSliderSimple("amplifier" + potion.getRegistryName(), (IFormattableTextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.amplifier"), value -> {
                this.builderPotion.setAmplifier(value.byteValue());
                this.builderPotionItem.setAmplifier(potion, value.byteValue());
            })));
        } else if (this.potionPage == 2) {
            Effect potion = this.builderPotion.getEffectAsPotion();
            container.add(new GuiSlider(x + 118, y, 114, 20, 0.0, 59.0, 0.0, container, new LogicSliderSimple("s" + potion.getRegistryName(), (IFormattableTextComponent)new TranslationTextComponent("gui.worldhandler.potion.time.seconds"), value -> {
                this.builderPotion.setSeconds((int)value);
                this.builderPotionItem.setSeconds(potion, (int)value);
            })));
            container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, 59.0, 0.0, container, new LogicSliderSimple("m" + potion.getRegistryName(), (IFormattableTextComponent)new TranslationTextComponent("gui.worldhandler.potion.time.minutes"), value -> {
                this.builderPotion.setMinutes((int)value);
                this.builderPotionItem.setMinutes(potion, (int)value);
            })));
            container.add(new GuiSlider(x + 118, y + 48, 114, 20, 0.0, 99.0, 0.0, container, new LogicSliderSimple("h" + potion.getRegistryName(), (IFormattableTextComponent)new TranslationTextComponent("gui.worldhandler.potion.time.hours"), value -> {
                this.builderPotion.setHours((int)value);
                this.builderPotionItem.setHours(potion, (int)value);
            })));
        } else if (this.potionPage == 3) {
            boolean enabled;
            button1 = new GuiButtonBase(x + 118, y, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotion.buildGive());
                this.potionPage = 0;
                container.func_231160_c_();
            });
            container.add(button1);
            GuiButtonBase button2 = new GuiButtonBase(x + 118, y + 24, 56, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.tipped_arrow"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotionItem.build(Items.field_185167_i));
                this.potionPage = 0;
                container.func_231160_c_();
            });
            container.add(button2);
            GuiButtonTooltip button3 = new GuiButtonTooltip(x + 178, y + 24, 55, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.bottle"), (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.place_command_block"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotionItem.build(Items.field_151068_bn));
                this.potionPage = 0;
                container.func_231160_c_();
            });
            container.add(button3);
            GuiButtonTooltip button4 = new GuiButtonTooltip(x + 118, y + 48, 56, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.splash"), (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.place_command_block"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotionItem.build(Items.field_185155_bH));
                this.potionPage = 0;
                container.func_231160_c_();
            });
            container.add(button4);
            GuiButtonTooltip button5 = new GuiButtonTooltip(x + 178, y + 48, 55, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.potions.effect.lingering"), (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.place_command_block"), () -> {
                CommandHelper.sendCommand(container.getPlayer(), this.builderPotionItem.build(Items.field_185156_bI));
                this.potionPage = 0;
                container.func_231160_c_();
            });
            container.add(button5);
            button1.field_230693_o_ = enabled = this.builderPotion.getAmplifier() >= 0 && this.builderPotion.getDuration() > 0;
            button2.field_230693_o_ = enabled;
            button3.field_230693_o_ = enabled;
            button4.field_230693_o_ = enabled;
            button5.field_230693_o_ = enabled;
        }
        if (this.potionPage > 0) {
            container.add(new GuiButtonBase(x + 118, y + 72, 56, 20, (ITextComponent)TextUtils.ARROW_LEFT, () -> {
                --this.potionPage;
                container.func_231160_c_();
            }));
            button1 = new GuiButtonBase(x + 118 + 60, y + 72, 55, 20, (ITextComponent)TextUtils.ARROW_RIGHT, () -> this.next(container));
            container.add(button1);
            button1.field_230693_o_ = this.potionPage < 3;
        }
    }

    private void next(Container container) {
        ++this.potionPage;
        container.func_231160_c_();
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.potions");
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderPotion.setPlayer(username);
        this.builderPotionItem.setPlayer(username);
    }
}

