/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.container.impl;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.event.KeyHandler;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.menu.IMenu;
import exopandora.worldhandler.gui.widget.IContainerWidget;
import exopandora.worldhandler.gui.widget.WidgetCommandSyntax;
import exopandora.worldhandler.gui.widget.WidgetNameField;
import exopandora.worldhandler.gui.widget.WidgetShortcuts;
import exopandora.worldhandler.gui.widget.WidgetTabRenderer;
import exopandora.worldhandler.gui.widget.WidgetWatch;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.RenderUtils;
import exopandora.worldhandler.util.ResourceHelper;
import exopandora.worldhandler.util.TextUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiWorldHandler
extends Container {
    private static String player = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private static final List<IContainerWidget> WIDGETS = (List)Util.func_200696_a((Object)Lists.newArrayList(), widgets -> {
        widgets.add(new WidgetTabRenderer());
        widgets.add(new WidgetWatch());
        widgets.add(new WidgetNameField());
        widgets.add(new WidgetCommandSyntax());
        widgets.add(new WidgetShortcuts());
    });
    private final Content content;

    public GuiWorldHandler(Content content) throws Exception {
        super((ITextComponent)content.getTitle());
        this.content = content;
        this.content.init(this);
    }

    @Override
    public void func_231160_c_() {
        ActionHelper.tryRun(() -> {
            this.widgetButtons.clear();
            this.menus.clear();
            this.field_230710_m_.clear();
            this.field_230705_e_.clear();
            int x = this.getContentX();
            int y = this.getContentY();
            this.content.onPlayerNameChanged(this.getPlayer());
            this.content.initGui(this, x, y);
            for (IMenu menu : this.menus) {
                menu.initGui(this);
            }
            for (IContainerWidget widget : WIDGETS) {
                if (!widget.isEnabled()) continue;
                widget.initGui(this, x, y);
            }
            this.initButtons();
        });
    }

    @Override
    public void initButtons() {
        ActionHelper.tryRun(() -> {
            this.field_230710_m_.clear();
            this.field_230705_e_.clear();
            this.content.initButtons(this, this.getContentX(), this.getContentY());
            this.widgetButtons.forEach(this::add);
            int x = this.getContentX();
            int y = this.getContentY();
            for (IContainerWidget widget : WIDGETS) {
                if (!widget.isEnabled()) continue;
                widget.initButtons(this, x, y);
            }
            for (IMenu menu : this.menus) {
                menu.initButtons(this);
            }
        });
    }

    public void func_231023_e_() {
        ActionHelper.tryRun(() -> {
            this.content.tick(this);
            for (IMenu menu : this.menus) {
                menu.tick();
            }
            for (IContainerWidget widget : WIDGETS) {
                if (!widget.isEnabled()) continue;
                widget.tick(this);
            }
        });
    }

    @Override
    public int getBackgroundX() {
        return (this.field_230708_k_ - this.getBackgroundWidth()) / 2;
    }

    @Override
    public int getBackgroundY() {
        return (this.field_230709_l_ - this.getBackgroundHeight()) / 2 + 10;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        ActionHelper.tryRun(() -> {
            int backgroundX = this.getBackgroundX();
            int backgroundY = this.getBackgroundY();
            if (Config.getSkin().drawBackground()) {
                this.func_230926_e_(-1);
                super.func_230446_a_(matrix);
            }
            RenderSystem.enableBlend();
            RenderUtils.colorDefaultBackground();
            this.bindBackground();
            this.func_238474_b_(matrix, backgroundX, backgroundY, 0, 0, this.getBackgroundWidth(), this.getBackgroundHeight());
            String label = "1.16.5-2.12.6";
            int versionWidth = this.field_230708_k_ - this.field_230712_o_.func_78256_a("1.16.5-2.12.6") - 2;
            int versionHeight = this.field_230709_l_ - 10;
            this.field_230712_o_.func_238421_b_(matrix, "1.16.5-2.12.6", (float)versionWidth, (float)versionHeight, Config.getSkin().getLabelColor() + 0x33000000);
            int x = this.getContentX();
            int y = this.getContentY();
            for (IContainerWidget widget : WIDGETS) {
                if (!widget.isEnabled() || IContainerWidget.EnumLayer.BACKGROUND != widget.getLayer()) continue;
                widget.drawScreen(matrix, this, x, y, mouseX, mouseY, partialTicks);
            }
            int maxWidth = this.getBackgroundWidth() - 18 - this.field_230712_o_.func_78256_a(this.getPlayer()) - (Config.getSettings().watch() ? 9 : 0);
            this.field_230712_o_.func_243248_b(matrix, (ITextComponent)TextUtils.stripText(this.content.getTitle(), maxWidth, this.field_230712_o_), (float)(backgroundX + 7), (float)(backgroundY + 7), Config.getSkin().getLabelColor());
            for (int i = 0; i < this.field_230710_m_.size(); ++i) {
                ((Widget)this.field_230710_m_.get(i)).func_230430_a_(matrix, mouseX, mouseY, partialTicks);
            }
            this.content.drawScreen(matrix, this, x, y, mouseX, mouseY, partialTicks);
            for (IMenu menu : this.menus) {
                menu.draw(matrix, mouseX, mouseY, partialTicks);
            }
            for (IContainerWidget widget : WIDGETS) {
                if (!widget.isEnabled() || IContainerWidget.EnumLayer.FOREGROUND != widget.getLayer()) continue;
                widget.drawScreen(matrix, this, x, y, mouseX, mouseY, partialTicks);
            }
            if (Config.getSettings().tooltips()) {
                for (Widget button : this.field_230710_m_) {
                    if (!(button instanceof GuiButtonTooltip)) continue;
                    ((GuiButtonTooltip)button).renderTooltip(this, matrix, mouseX, mouseY);
                }
            }
            if (mouseX >= versionWidth && mouseY >= versionHeight) {
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)(versionWidth - 12), (double)(versionHeight + 12), 0.0);
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent("1.16.5-2.12.6"), 0, 0);
                matrix.func_227865_b_();
            }
            RenderSystem.disableBlend();
        });
    }

    public void func_212927_b(double xPos, double mouseY) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled()) continue;
            widget.func_212927_b(xPos, mouseY);
        }
        this.content.func_212927_b(xPos, mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int keyCode) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.func_231044_a_(mouseX, mouseY, keyCode)) continue;
            return true;
        }
        if (this.content.func_231044_a_(mouseX, mouseY, keyCode)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, keyCode);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int keyCode) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.func_231048_c_(mouseX, mouseY, keyCode)) continue;
            return true;
        }
        if (this.content.func_231048_c_(mouseX, mouseY, keyCode)) {
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, keyCode);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int keyCode, double deltaX, double deltaY) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.func_231045_a_(mouseX, mouseY, keyCode, deltaX, deltaY)) continue;
            return true;
        }
        if (this.content.func_231045_a_(mouseX, mouseY, keyCode, deltaX, deltaY)) {
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, keyCode, deltaX, deltaY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double distance) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.func_231043_a_(mouseX, mouseY, distance)) continue;
            return true;
        }
        if (this.content.func_231043_a_(mouseX, mouseY, distance)) {
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, distance);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean focused;
        boolean bl = focused = this.func_241217_q_() != null;
        if (focused && this.func_241217_q_() instanceof Widget) {
            focused = ((Widget)this.func_241217_q_()).func_230999_j_();
        }
        if (!focused && KeyHandler.KEY_WORLD_HANDLER.func_197976_a(keyCode, scanCode) && KeyHandler.KEY_WORLD_HANDLER.getKeyModifier().isActive(null)) {
            Minecraft.func_71410_x().func_147108_a(null);
            return true;
        }
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.func_231046_a_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (this.content.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.func_223281_a_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (this.content.func_223281_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char charTyped, int keyCode) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.func_231042_a_(charTyped, keyCode)) continue;
            return true;
        }
        if (this.content.func_231042_a_(charTyped, keyCode)) {
            return true;
        }
        return super.func_231042_a_(charTyped, keyCode);
    }

    public boolean func_231049_c__(boolean focus) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.func_231049_c__(focus)) continue;
            return true;
        }
        if (this.content.func_231049_c__(focus)) {
            return true;
        }
        return super.func_231049_c__(focus);
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        for (IContainerWidget widget : WIDGETS) {
            if (!widget.isEnabled() || !widget.func_231047_b_(mouseX, mouseY)) continue;
            return true;
        }
        if (this.content.func_231047_b_(mouseX, mouseY)) {
            return true;
        }
        return super.func_231047_b_(mouseX, mouseY);
    }

    private int getContentX() {
        return this.getBackgroundX() + 8;
    }

    private int getContentY() {
        return this.getBackgroundY() + 33;
    }

    public void func_231175_as__() {
        ActionHelper.tryRun(this.content::onGuiClosed);
        super.func_231175_as__();
    }

    public boolean func_231177_au__() {
        return Config.getSettings().pause();
    }

    @Override
    public String getPlayer() {
        return player;
    }

    @Override
    public void setPlayer(String player) {
        GuiWorldHandler.player = player;
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    @Override
    public int getBackgroundWidth() {
        return 248;
    }

    @Override
    public int getBackgroundHeight() {
        return 166;
    }

    @Override
    public void bindBackground() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceHelper.backgroundTexture());
    }
}

