/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Parsers;
import com.ldtteam.blockout.controls.Image;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;

public class ImageRepeatable
extends Pane {
    public static final int MINECRAFT_DEFAULT_TEXTURE_IMAGE_SIZE = 256;
    protected ResourceLocation resourceLocation;
    protected int u = 0;
    protected int v = 0;
    protected int uWidth = 0;
    protected int vHeight = 0;
    protected int uRepeat = 0;
    protected int vRepeat = 0;
    protected int repeatWidth = 0;
    protected int repeatHeight = 0;
    protected int fileWidth = 256;
    protected int fileHeight = 256;

    public ImageRepeatable() {
    }

    public ImageRepeatable(PaneParams params) {
        super(params);
        this.resourceLocation = params.getResource("source", this::loadMapDimensions);
        params.applyShorthand("textureoffset", Parsers.INT, 2, a -> {
            this.u = (Integer)a.get(0);
            this.v = (Integer)a.get(1);
        });
        params.applyShorthand("texturesize", Parsers.INT, 2, a -> {
            this.uWidth = (Integer)a.get(0);
            this.vHeight = (Integer)a.get(1);
        });
        params.applyShorthand("repeatoffset", Parsers.INT, 2, a -> {
            this.uRepeat = (Integer)a.get(0);
            this.vRepeat = (Integer)a.get(1);
        });
        params.applyShorthand("repeatsize", Parsers.INT, 2, a -> {
            this.repeatWidth = (Integer)a.get(0);
            this.repeatHeight = (Integer)a.get(1);
        });
    }

    private void loadMapDimensions(ResourceLocation rl) {
        Tuple<Integer, Integer> dimensions = Image.getImageDimensions(rl);
        this.fileWidth = (Integer)dimensions.func_76341_a();
        this.fileHeight = (Integer)dimensions.func_76340_b();
    }

    public void setImageLoc(String source) {
        this.setImageLoc(source != null ? new ResourceLocation(source) : null);
    }

    public void setImageLoc(ResourceLocation loc) {
        this.resourceLocation = loc;
    }

    public void setImageSize(int u, int v, int uWidth, int vHeight, int uRepeat, int vRepeat, int repeatWidth, int repeatHeight) {
        this.u = u;
        this.v = v;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.uRepeat = uRepeat;
        this.vRepeat = vRepeat;
        this.repeatWidth = repeatWidth;
        this.repeatHeight = repeatHeight;
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        this.mc.func_110434_K().func_110577_a(this.resourceLocation);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        ImageRepeatable.blitRepeatable(ms, this.x, this.y, this.width, this.height, this.u, this.v, this.uWidth, this.vHeight, this.fileWidth, this.fileHeight, this.uRepeat, this.vRepeat, this.repeatWidth, this.repeatHeight);
        RenderSystem.disableBlend();
    }
}

