/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.items.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.easy_villagers.corelib.CachedMap;
import de.maxhenkel.easy_villagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.blocks.tileentity.FakeWorldTileentity;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockItemRendererBase<T extends TileEntityRenderer<U>, U extends FakeWorldTileentity>
extends ItemStackTileEntityRenderer {
    private Function<TileEntityRendererDispatcher, T> rendererSupplier;
    private Supplier<U> tileEntitySupplier;
    private T renderer;
    private Minecraft minecraft;
    private CachedMap<ItemStack, U> cachedMap;

    public BlockItemRendererBase(Function<TileEntityRendererDispatcher, T> rendererSupplier, Supplier<U> tileentitySupplier) {
        this.rendererSupplier = rendererSupplier;
        this.tileEntitySupplier = tileentitySupplier;
        this.cachedMap = new CachedMap(10000L, ItemUtils.ITEM_COMPARATOR);
        this.minecraft = Minecraft.func_71410_x();
    }

    public void func_239207_a_(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (this.renderer == null) {
            this.renderer = (TileEntityRenderer)this.rendererSupplier.apply(TileEntityRendererDispatcher.field_147556_a);
        }
        CompoundNBT blockEntityTag = itemStack.func_179543_a("BlockEntityTag");
        FakeWorldTileentity tileEntity = this.cachedMap.get(itemStack, () -> {
            FakeWorldTileentity te = (FakeWorldTileentity)((Object)((Object)this.tileEntitySupplier.get()));
            te.setFakeWorld((World)this.minecraft.field_71441_e);
            if (blockEntityTag != null) {
                te.func_230337_a_(null, blockEntityTag);
            }
            return te;
        });
        this.renderer.func_225616_a_((TileEntity)tileEntity, 0.0f, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }
}

