/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.ResourceUtil;
import com.jozufozu.flywheel.backend.ShaderContext;
import com.jozufozu.flywheel.backend.ShaderSources;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.loading.InstancedArraysTemplate;
import com.jozufozu.flywheel.backend.loading.Program;
import com.jozufozu.flywheel.backend.loading.ProgramTemplate;
import com.jozufozu.flywheel.backend.loading.Shader;
import com.jozufozu.flywheel.backend.loading.ShaderLoadingException;
import com.jozufozu.flywheel.backend.loading.ShaderTransformer;
import com.jozufozu.flywheel.backend.material.MaterialSpec;
import com.jozufozu.flywheel.core.shader.ExtensibleGlProgram;
import com.jozufozu.flywheel.core.shader.StateSensitiveMultiProgram;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.core.shader.spec.ProgramSpec;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;

public class WorldContext<P extends WorldProgram>
extends ShaderContext<P> {
    private static final String declaration = "#flwbuiltins";
    private static final Pattern builtinPattern = Pattern.compile("#flwbuiltins");
    protected ResourceLocation name;
    protected Supplier<Stream<ResourceLocation>> specStream;
    protected TemplateFactory templateFactory;
    private final Map<ShaderType, ResourceLocation> builtins = new EnumMap<ShaderType, ResourceLocation>(ShaderType.class);
    private final Map<ShaderType, String> builtinSources = new EnumMap<ShaderType, String>(ShaderType.class);
    private final ExtensibleGlProgram.Factory<P> factory;
    protected ShaderTransformer transformer;
    protected ProgramTemplate template;

    public WorldContext(Backend backend, ExtensibleGlProgram.Factory<P> factory) {
        super(backend);
        this.factory = factory;
        this.specStream = () -> backend.allMaterials().stream().map(MaterialSpec::getProgramName);
        this.templateFactory = InstancedArraysTemplate::new;
    }

    public WorldContext<P> withName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    public WorldContext<P> withBuiltin(ShaderType shaderType, ResourceLocation folder, String file) {
        return this.withBuiltin(shaderType, ResourceUtil.subPath(folder, file));
    }

    public WorldContext<P> withBuiltin(ShaderType shaderType, ResourceLocation file) {
        this.builtins.put(shaderType, file);
        return this;
    }

    public WorldContext<P> withSpecStream(Supplier<Stream<ResourceLocation>> specStream) {
        this.specStream = specStream;
        return this;
    }

    public WorldContext<P> withTemplateFactory(TemplateFactory templateFactory) {
        this.templateFactory = templateFactory;
        return this;
    }

    @Override
    public void load() {
        Backend.log.info("Loading context '{}'", (Object)this.name);
        try {
            this.builtins.forEach((type, resourceLocation) -> this.builtinSources.put((ShaderType)((Object)type), this.backend.sources.getShaderSource((ResourceLocation)resourceLocation)));
        }
        catch (ShaderLoadingException e) {
            this.backend.sources.notifyError();
            Backend.log.error(String.format("Could not find builtin: %s", e.getMessage()));
            return;
        }
        this.template = this.templateFactory.create(this.backend.sources);
        this.transformer = new ShaderTransformer().pushStage(this::injectBuiltins).pushStage(Shader::processIncludes).pushStage(this.template).pushStage(Shader::processIncludes);
        this.specStream.get().map(this.backend::getSpec).forEach(spec -> {
            try {
                this.programs.put(spec.name, new StateSensitiveMultiProgram<P>(this.factory, this, (ProgramSpec)spec));
                Backend.log.debug("Loaded program {}", (Object)spec.name);
            }
            catch (Exception e) {
                Backend.log.error("Program '{}': {}", (Object)spec.name, (Object)e);
                this.backend.sources.notifyError();
            }
        });
    }

    @Override
    protected Shader getSource(ShaderType type, ResourceLocation name) {
        Shader source = super.getSource(type, name);
        this.transformer.transformSource(source);
        return source;
    }

    @Override
    protected Program link(Program program) {
        this.template.attachAttributes(program);
        return super.link(program);
    }

    public void injectBuiltins(Shader shader) {
        Matcher matcher = builtinPattern.matcher(shader.getSource());
        if (!matcher.find()) {
            throw new ShaderLoadingException(String.format("%s is missing %s, cannot use in World Context", shader.type.name, declaration));
        }
        shader.setSource(matcher.replaceFirst(this.builtinSources.get((Object)shader.type)));
    }

    public static interface TemplateFactory {
        public ProgramTemplate create(ShaderSources var1);
    }
}

