/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import appeng.util.item.AESharedItemStack;
import appeng.util.item.MeaningfulItemIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

abstract class ItemVariantList {
    ItemVariantList() {
    }

    public void add(IAEItemStack option) {
        IAEItemStack st = this.getRecords().get(((AEItemStack)option).getSharedStack());
        if (st != null) {
            st.add(option);
            return;
        }
        IAEItemStack opt = option.copy();
        this.putItemRecord(opt);
    }

    public IAEItemStack findPrecise(IAEItemStack itemStack) {
        return this.getRecords().get(((AEItemStack)itemStack).getSharedStack());
    }

    public void addStorage(IAEItemStack option) {
        IAEItemStack st = this.getRecords().get(((AEItemStack)option).getSharedStack());
        if (st != null) {
            st.incStackSize(option.getStackSize());
            return;
        }
        IAEItemStack opt = option.copy();
        this.putItemRecord(opt);
    }

    public void addCrafting(IAEItemStack option) {
        IAEItemStack st = this.getRecords().get(((AEItemStack)option).getSharedStack());
        if (st != null) {
            st.setCraftable(true);
            return;
        }
        IAEItemStack opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(true);
        this.putItemRecord(opt);
    }

    public void addRequestable(IAEItemStack option) {
        IAEItemStack st = this.getRecords().get(((AEItemStack)option).getSharedStack());
        if (st != null) {
            st.setCountRequestable(st.getCountRequestable() + option.getCountRequestable());
            return;
        }
        IAEItemStack opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(false);
        opt.setCountRequestable(option.getCountRequestable());
        this.putItemRecord(opt);
    }

    public int size() {
        int size = 0;
        for (IAEItemStack entry : this.getRecords().values()) {
            if (!entry.isMeaningful()) continue;
            ++size;
        }
        return size;
    }

    public Iterator<IAEItemStack> iterator() {
        return new MeaningfulItemIterator<IAEItemStack>(this.getRecords().values());
    }

    private void putItemRecord(IAEItemStack itemStack) {
        this.getRecords().put(((AEItemStack)itemStack).getSharedStack(), itemStack);
    }

    abstract Map<AESharedItemStack, IAEItemStack> getRecords();

    public abstract Collection<IAEItemStack> findFuzzy(IAEItemStack var1, FuzzyMode var2);
}

