/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.CopyMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.util.IConfigManager;
import appeng.tile.AEBaseTileEntity;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CellWorkbenchTileEntity
extends AEBaseTileEntity
implements IUpgradeableHost,
IAEAppEngInventory,
IConfigManagerHost {
    private final AppEngInternalInventory cell = new AppEngInternalInventory(this, 1);
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 63);
    private final ConfigManager manager = new ConfigManager(this);
    private IItemHandler cacheUpgrades = null;
    private IItemHandler cacheConfig = null;
    private boolean locked = false;

    public CellWorkbenchTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.manager.registerSetting(Settings.COPY_MODE, (Enum)CopyMode.CLEAR_ON_REMOVE);
        this.cell.setEnableClientEvents(true);
    }

    public IItemHandler getCellUpgradeInventory() {
        if (this.cacheUpgrades == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            ItemStack is = this.cell.getStackInSlot(0);
            if (is.func_190926_b()) {
                return null;
            }
            IItemHandler inv = cell.getUpgradesInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheUpgrades = inv;
            return this.cacheUpgrades;
        }
        return this.cacheUpgrades;
    }

    public ICellWorkbenchItem getCell() {
        if (this.cell.getStackInSlot(0).func_190926_b()) {
            return null;
        }
        if (this.cell.getStackInSlot(0).func_77973_b() instanceof ICellWorkbenchItem) {
            return (ICellWorkbenchItem)this.cell.getStackInSlot(0).func_77973_b();
        }
        return null;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        this.cell.writeToNBT(data, "cell");
        this.config.writeToNBT(data, "config");
        this.manager.writeToNBT(data);
        return data;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        this.cell.readFromNBT(data, "cell");
        this.config.readFromNBT(data, "config");
        this.manager.readFromNBT(data);
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        if (name.equals("cell")) {
            return this.cell;
        }
        return null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return 0;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.cell && !this.locked) {
            this.locked = true;
            this.cacheUpgrades = null;
            this.cacheConfig = null;
            IItemHandler configInventory = this.getCellConfigInventory();
            if (configInventory != null) {
                int x;
                boolean cellHasConfig = false;
                for (x = 0; x < configInventory.getSlots(); ++x) {
                    if (configInventory.getStackInSlot(x).func_190926_b()) continue;
                    cellHasConfig = true;
                    break;
                }
                if (cellHasConfig) {
                    for (x = 0; x < this.config.getSlots(); ++x) {
                        this.config.setStackInSlot(x, configInventory.getStackInSlot(x));
                    }
                } else {
                    ItemHandlerUtil.copy((IItemHandler)this.config, configInventory, false);
                }
            } else if (this.manager.getSetting(Settings.COPY_MODE) == CopyMode.CLEAR_ON_REMOVE) {
                for (int x = 0; x < this.config.getSlots(); ++x) {
                    this.config.setStackInSlot(x, ItemStack.field_190927_a);
                }
                this.saveChanges();
            }
            this.locked = false;
        } else if (inv == this.config && !this.locked) {
            this.locked = true;
            IItemHandler c = this.getCellConfigInventory();
            if (c != null) {
                ItemHandlerUtil.copy((IItemHandler)this.config, c, false);
                ItemHandlerUtil.copy(c, (IItemHandler)this.config, false);
            }
            this.locked = false;
        }
    }

    private IItemHandler getCellConfigInventory() {
        if (this.cacheConfig == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            ItemStack is = this.cell.getStackInSlot(0);
            if (is.func_190926_b()) {
                return null;
            }
            IItemHandler inv = cell.getConfigInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheConfig = inv;
        }
        return this.cacheConfig;
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        super.getDrops(w, pos, drops);
        if (this.cell.getStackInSlot(0) != null) {
            drops.add(this.cell.getStackInSlot(0));
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
    }
}

