/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.grindstone;

import appeng.api.implementations.tiles.ICrankable;
import appeng.tile.AEBaseTileEntity;
import java.io.IOException;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;

public class CrankTileEntity
extends AEBaseTileEntity
implements ITickableTileEntity {
    private final int ticksPerRotation = 18;
    private float visibleRotation = 0.0f;
    private int charge = 0;
    private int hits = 0;
    private int rotation = 0;

    public CrankTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        if (this.rotation > 0) {
            float f = this.getVisibleRotation();
            this.getClass();
            this.setVisibleRotation(f - 360.0f / 18.0f);
            ++this.charge;
            if (this.charge >= this.ticksPerRotation) {
                this.charge -= this.ticksPerRotation;
                ICrankable g = this.getGrinder();
                if (g != null) {
                    g.applyTurn();
                }
            }
            --this.rotation;
        }
    }

    private ICrankable getGrinder() {
        if (this.isRemote()) {
            return null;
        }
        Direction grinder = this.getUp().func_176734_d();
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(grinder));
        if (te instanceof ICrankable) {
            return (ICrankable)te;
        }
        return null;
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        this.rotation = data.readInt();
        return c;
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeInt(this.rotation);
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        state.func_177230_c().func_220069_a(state, this.field_145850_b, this.field_174879_c, state.func_177230_c(), this.field_174879_c, false);
    }

    public boolean power() {
        ICrankable g;
        if (this.isRemote()) {
            return false;
        }
        if (this.rotation < 3 && (g = this.getGrinder()) != null) {
            if (g.canTurn()) {
                this.hits = 0;
                this.rotation += this.ticksPerRotation;
                this.markForUpdate();
                return true;
            }
            ++this.hits;
            if (this.hits > 10) {
                this.field_145850_b.func_175655_b(this.field_174879_c, false);
            }
        }
        return false;
    }

    public float getVisibleRotation() {
        return this.visibleRotation;
    }

    private void setVisibleRotation(float visibleRotation) {
        this.visibleRotation = visibleRotation;
    }
}

