/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.items;

import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.core.Api;
import appeng.fluids.helper.FluidCellConfig;
import appeng.items.materials.MaterialType;
import appeng.items.storage.AbstractStorageCell;
import appeng.util.InventoryAdaptor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public final class BasicFluidStorageCell
extends AbstractStorageCell<IAEFluidStack> {
    private final int perType;
    private final double idleDrain;

    public BasicFluidStorageCell(Item.Properties props, MaterialType whichCell, int kilobytes) {
        super(props, whichCell, kilobytes);
        switch (whichCell) {
            case FLUID_1K_CELL_COMPONENT: {
                this.idleDrain = 0.5;
                this.perType = 8;
                break;
            }
            case FLUID_4K_CELL_COMPONENT: {
                this.idleDrain = 1.0;
                this.perType = 32;
                break;
            }
            case FLUID_16K_CELL_COMPONENT: {
                this.idleDrain = 1.5;
                this.perType = 128;
                break;
            }
            case FLUID_64K_CELL_COMPONENT: {
                this.idleDrain = 2.0;
                this.perType = 512;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 5;
    }

    @Override
    public IItemHandler getConfigInventory(ItemStack is) {
        return new FluidCellConfig(is);
    }

    @Override
    protected void dropEmptyStorageCellCase(InventoryAdaptor ia, PlayerEntity player) {
        Api.instance().definitions().materials().emptyStorageCell().maybeStack(1).ifPresent(is -> {
            ItemStack extraA = ia.addItems((ItemStack)is);
            if (!extraA.func_190926_b()) {
                player.func_71019_a(extraA, false);
            }
        });
    }
}

