/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.client.gui.Icon;
import appeng.container.AEBaseContainer;
import appeng.container.SlotSemantic;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.items.contents.QuartzKnifeObj;
import appeng.tile.inventory.AppEngInternalInventory;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class QuartzKnifeContainer
extends AEBaseContainer {
    public static final ContainerType<QuartzKnifeContainer> TYPE = ContainerTypeBuilder.create(QuartzKnifeContainer::new, QuartzKnifeObj.class).build("quartzknife");
    private final QuartzKnifeObj toolInv;
    private final IItemHandler inSlot = new AppEngInternalInventory(null, 1, 1);
    private String currentName = "";

    public QuartzKnifeContainer(int id, PlayerInventory ip, QuartzKnifeObj te) {
        super(TYPE, id, ip, te);
        this.toolInv = te;
        this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.METAL_INGOTS, this.inSlot, 0), SlotSemantic.MACHINE_INPUT);
        this.addSlot(new QuartzKniveSlot(this.inSlot, 0, null), SlotSemantic.MACHINE_OUTPUT);
        this.lockPlayerInventorySlot(ip.field_70461_c);
        this.createPlayerInventorySlots(ip);
    }

    public void setName(String value) {
        this.currentName = value;
    }

    @Override
    public void func_75142_b() {
        if (!this.ensureGuiItemIsInSlot(this.toolInv, this.getPlayerInventory().field_70461_c)) {
            this.setValidContainer(false);
            return;
        }
        super.func_75142_b();
    }

    public void func_75134_a(PlayerEntity player) {
        ItemStack item = this.inSlot.extractItem(0, Integer.MAX_VALUE, false);
        if (!item.func_190926_b()) {
            player.func_71019_a(item, false);
        }
    }

    private class QuartzKniveSlot
    extends OutputSlot {
        QuartzKniveSlot(IItemHandler inv, int invSlot, Icon icon) {
            super(inv, invSlot, icon);
        }

        @Override
        public ItemStack func_75211_c() {
            IItemHandler baseInv = this.getItemHandler();
            ItemStack input = baseInv.getStackInSlot(0);
            if (input == ItemStack.field_190927_a) {
                return ItemStack.field_190927_a;
            }
            if (RestrictedInputSlot.isMetalIngot(input) && QuartzKnifeContainer.this.currentName.length() > 0) {
                return Api.instance().definitions().materials().namePress().maybeStack(1).map(namePressStack -> {
                    CompoundNBT compound = namePressStack.func_196082_o();
                    compound.func_74778_a("InscribeName", QuartzKnifeContainer.this.currentName);
                    return namePressStack;
                }).orElse(ItemStack.field_190927_a);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        @Nonnull
        public ItemStack func_75209_a(int amount) {
            ItemStack ret = this.func_75211_c();
            if (!ret.func_190926_b()) {
                this.makePlate();
            }
            return ret;
        }

        @Override
        public void func_75215_d(ItemStack stack) {
            if (stack.func_190926_b()) {
                this.makePlate();
            }
        }

        private void makePlate() {
            if (QuartzKnifeContainer.this.isServer() && !this.getItemHandler().extractItem(0, 1, false).func_190926_b()) {
                ItemStack item = QuartzKnifeContainer.this.toolInv.getItemStack();
                ItemStack before = item.func_77946_l();
                PlayerInventory playerInv = QuartzKnifeContainer.this.getPlayerInventory();
                item.func_222118_a(1, (LivingEntity)playerInv.field_70458_d, p -> {
                    playerInv.func_70299_a(playerInv.field_70461_c, ItemStack.field_190927_a);
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(playerInv.field_70458_d, before, null));
                });
                QuartzKnifeContainer.this.func_75142_b();
            }
        }
    }
}

