/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.util.IConfigManager;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.FakeSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;

public class InterfaceContainer
extends UpgradeableContainer {
    public static final ContainerType<InterfaceContainer> TYPE = ContainerTypeBuilder.create(InterfaceContainer::new, IInterfaceHost.class).requirePermission(SecurityPermissions.BUILD).build("interface");
    @GuiSync(value=3)
    public YesNo bMode = YesNo.NO;
    @GuiSync(value=4)
    public YesNo iTermMode = YesNo.YES;

    public InterfaceContainer(int id, PlayerInventory ip, IInterfaceHost te) {
        super(TYPE, id, ip, te.getInterfaceDuality().getHost());
        int x;
        DualityInterface duality = te.getInterfaceDuality();
        for (x = 0; x < 9; ++x) {
            this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, duality.getPatterns(), x), SlotSemantic.ENCODED_PATTERN);
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new FakeSlot(duality.getConfig(), x), SlotSemantic.CONFIG);
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new AppEngSlot(duality.getStorage(), x), SlotSemantic.STORAGE);
        }
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    public int availableUpgrades() {
        return 1;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        super.func_75142_b();
    }

    @Override
    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setBlockingMode((YesNo)cm.getSetting(Settings.BLOCK));
        this.setInterfaceTerminalMode((YesNo)cm.getSetting(Settings.INTERFACE_TERMINAL));
    }

    public YesNo getBlockingMode() {
        return this.bMode;
    }

    private void setBlockingMode(YesNo bMode) {
        this.bMode = bMode;
    }

    public YesNo getInterfaceTerminalMode() {
        return this.iTermMode;
    }

    private void setInterfaceTerminalMode(YesNo iTermMode) {
        this.iTermMode = iTermMode;
    }
}

