/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mod.chiselsandbits.api.util.MathUtil;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.NotNull;

public class DirectionUtils {
    private DirectionUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: DirectionUtils. This is a utility class");
    }

    public static List<Direction> getNotOnAxisOf(@NotNull Direction direction) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (Direction d : Direction.values()) {
            if (d.func_176740_k() == direction.func_176740_k()) continue;
            list.add(d);
        }
        return list;
    }

    public static Optional<Direction> getDirectionVectorBetweenIfAligned(Vector3d l, Vector3d r) {
        return DirectionUtils.getDirectionVectorIfAligned(l.func_178788_d(r));
    }

    public static Optional<Direction> getDirectionVectorIfAligned(Vector3d vector) {
        Vector3d scaledToOne = VectorUtils.scaleToOne(vector);
        if (MathUtil.almostEqual(scaledToOne.func_82615_a(), 0)) {
            if (MathUtil.almostEqual(scaledToOne.func_82617_b(), 0)) {
                if (MathUtil.almostEqual(scaledToOne.func_82616_c(), 0)) {
                    return Optional.empty();
                }
                return Optional.of(scaledToOne.func_82616_c() < 0.0 ? Direction.NORTH : Direction.SOUTH);
            }
            if (MathUtil.almostEqual(scaledToOne.func_82616_c(), 0)) {
                return Optional.of(scaledToOne.func_82617_b() < 0.0 ? Direction.DOWN : Direction.UP);
            }
            return Optional.empty();
        }
        if (MathUtil.almostEqual(scaledToOne.func_82617_b(), 0)) {
            if (MathUtil.almostEqual(scaledToOne.func_82616_c(), 0)) {
                return Optional.of(scaledToOne.func_82616_c() < 0.0 ? Direction.WEST : Direction.EAST);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

