/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.tileentities;

import com.ldtteam.storageracks.ItemStorage;
import com.ldtteam.storageracks.blocks.RackBlock;
import com.ldtteam.storageracks.blocks.RackType;
import com.ldtteam.storageracks.inv.ContainerRack;
import com.ldtteam.storageracks.tileentities.AbstractTileEntityRack;
import com.ldtteam.storageracks.tileentities.ModTileEntities;
import com.ldtteam.storageracks.tileentities.TileEntityController;
import com.ldtteam.storageracks.utils.ItemStackUtils;
import com.ldtteam.storageracks.utils.WorldUtil;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityRack
extends AbstractTileEntityRack {
    private final Map<ItemStorage, Integer> content = new HashMap<ItemStorage, Integer>();
    private int size = 0;
    private int freeSlots = 0;
    private BlockPos controller;
    private LazyOptional<IItemHandler> lastOptional;

    public TileEntityRack() {
        super(ModTileEntities.RACK);
    }

    public void func_189667_a(Rotation rotationIn) {
        super.func_189667_a(rotationIn);
        if (this.controller != null) {
            this.controller = this.controller.func_190942_a(rotationIn);
        }
    }

    @Override
    public int getFreeSlots() {
        return this.freeSlots;
    }

    @Override
    public boolean hasItemStack(ItemStack stack, int count) {
        ItemStorage checkItem = new ItemStorage(stack);
        return this.content.getOrDefault(checkItem, 0) >= count;
    }

    @Override
    public int getCount(ItemStack stack) {
        ItemStorage checkItem = new ItemStorage(stack);
        return this.content.getOrDefault(checkItem, 0);
    }

    @Override
    public boolean hasItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!itemStackSelectionPredicate.test(entry.getKey().getItemStack())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSimilarStack(@NotNull ItemStack stack) {
        ItemStorage checkItem = new ItemStorage(stack);
        if (this.content.containsKey(checkItem)) {
            return true;
        }
        for (ItemStorage storage : this.content.keySet()) {
            if (checkItem.getPrimaryCreativeTabIndex() != storage.getPrimaryCreativeTabIndex()) continue;
            return true;
        }
        return false;
    }

    public Map<ItemStorage, Integer> getAllContent() {
        return this.content;
    }

    @Override
    public void upgradeItemStorage() {
        AbstractTileEntityRack.RackInventory tempInventory = new AbstractTileEntityRack.RackInventory(18 + this.size * 9);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            tempInventory.setStackInSlot(slot, this.inventory.getStackInSlot(slot));
        }
        this.inventory = tempInventory;
        this.invalidateCap();
    }

    @Override
    public int getItemCount(Predicate<ItemStack> predicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!predicate.test(entry.getKey().getItemStack())) continue;
            return entry.getValue();
        }
        return 0;
    }

    @Override
    public void updateItemStorage() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean empty = this.content.isEmpty();
            this.updateContent();
            if (empty && !this.content.isEmpty() || !empty && this.content.isEmpty()) {
                this.updateBlockState();
            }
            this.func_70296_d();
        }
    }

    private void updateContent() {
        this.content.clear();
        this.freeSlots = 0;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                ++this.freeSlots;
                continue;
            }
            ItemStorage storage = new ItemStorage(stack.func_77946_l());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey(storage)) {
                amount += this.content.remove(storage).intValue();
            }
            this.content.put(storage, amount);
        }
    }

    @Override
    public void updateBlockState() {
        if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() instanceof RackBlock) {
            if (this.content.isEmpty()) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()).func_206870_a(RackBlock.VARIANT, (Comparable)((Object)RackType.DEFAULT)), 3);
            } else {
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()).func_206870_a(RackBlock.VARIANT, (Comparable)((Object)RackType.FULL)), 3);
            }
        }
    }

    @Override
    public ItemStackHandler createInventory(int slots) {
        return new AbstractTileEntityRack.RackInventory(slots);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        int oldSize = compound.func_74762_e("tagSIze");
        this.checkForUpgrade(state, oldSize);
        this.inventory = this.createInventory(18 + this.size * 9);
        ListNBT inventoryTagList = compound.func_150295_c("inventory", 10);
        for (int i = 0; i < inventoryTagList.size(); ++i) {
            CompoundNBT inventoryCompound = inventoryTagList.func_150305_b(i);
            if (inventoryCompound.func_74764_b("empty")) continue;
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)inventoryCompound);
            this.inventory.setStackInSlot(i, stack);
        }
        this.updateContent();
        this.controllerPos = BlockPosUtil.readFromNBT((CompoundNBT)compound, (String)"pos");
        this.invalidateCap();
    }

    public void checkForUpgrade(BlockState state, int oldSize) {
        if (state.func_177230_c().getRegistryName().func_110623_a().contains("stone")) {
            this.size = 1;
        } else if (state.func_177230_c().getRegistryName().func_110623_a().contains("iron")) {
            this.size = 2;
        } else if (state.func_177230_c().getRegistryName().func_110623_a().contains("gold")) {
            this.size = 3;
        } else if (state.func_177230_c().getRegistryName().func_110623_a().contains("emerald")) {
            this.size = 4;
        } else if (state.func_177230_c().getRegistryName().func_110623_a().contains("diamond")) {
            this.size = 5;
        }
        if (oldSize != this.size) {
            this.upgradeItemStorage();
        }
    }

    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("tagSIze", this.size);
        ListNBT inventoryTagList = new ListNBT();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            CompoundNBT inventoryCompound = new CompoundNBT();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.func_190926_b()) {
                inventoryCompound.func_74757_a("empty", true);
            } else {
                stack.func_77955_b(inventoryCompound);
            }
            inventoryTagList.add((Object)inventoryCompound);
        }
        compound.func_218657_a("inventory", (INBT)inventoryTagList);
        BlockPosUtil.writeToNBT((CompoundNBT)compound, (String)"pos", (BlockPos)this.controllerPos);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(compound));
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction dir) {
        if (!this.field_145846_f && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.lastOptional != null && this.lastOptional.isPresent()) {
                return this.lastOptional.cast();
            }
            this.lastOptional = LazyOptional.of(() -> {
                if (this.func_145837_r()) {
                    return new AbstractTileEntityRack.RackInventory(0);
                }
                return this.getInventory();
            });
            return this.lastOptional.cast();
        }
        return super.getCapability(capability, dir);
    }

    public void func_70296_d() {
        WorldUtil.markChunkDirty(this.field_145850_b, this.func_174877_v());
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
        return new ContainerRack(id, inv, this.func_174877_v());
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.title.rack");
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateCap();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.invalidateCap();
    }

    private void invalidateCap() {
        if (this.lastOptional != null && this.lastOptional.isPresent()) {
            this.lastOptional.invalidate();
        }
        this.lastOptional = null;
    }

    public int getSize() {
        return this.size;
    }

    public void neighborChange() {
        HashSet<BlockPos> visitedPositions = new HashSet<BlockPos>();
        BlockPos controller = TileEntityRack.visitPositions(this.field_145850_b, visitedPositions, this.func_174877_v());
        if (controller != BlockPos.field_177992_a && controller != null) {
            this.controller = this.func_174877_v().func_177973_b((Vector3i)controller);
            ((TileEntityController)this.field_145850_b.func_175625_s(controller)).addAll(visitedPositions);
            for (BlockPos pos : visitedPositions) {
                if (pos.equals((Object)controller)) continue;
                ((TileEntityRack)this.field_145850_b.func_175625_s((BlockPos)pos)).controller = pos.func_177973_b((Vector3i)controller);
            }
        } else if (controller == null) {
            TileEntityController te;
            BlockPos oldController = null;
            for (BlockPos pos : visitedPositions) {
                TileEntityRack rack = (TileEntityRack)this.field_145850_b.func_175625_s(pos);
                if (rack.controller == null) continue;
                oldController = rack.func_174877_v().func_177973_b((Vector3i)rack.controller);
                rack.controller = null;
            }
            if (oldController != null && (te = (TileEntityController)this.field_145850_b.func_175625_s(oldController)) != null) {
                te.removeAll(visitedPositions);
            }
        }
    }

    public static BlockPos visitPositions(World level, Set<BlockPos> visitedPositions, BlockPos current) {
        BlockPos controller = null;
        if (level.func_175625_s(current) instanceof TileEntityController) {
            controller = current;
        }
        visitedPositions.add(current);
        for (Direction dir : Direction.values()) {
            BlockPos cont;
            TileEntity te;
            BlockPos next = current.func_177972_a(dir);
            if (visitedPositions.contains(next) || !((te = level.func_175625_s(next)) instanceof TileEntityRack) && !(te instanceof TileEntityController) || (cont = TileEntityRack.visitPositions(level, visitedPositions, next)) == null) continue;
            if (cont.equals((Object)BlockPos.field_177992_a) || controller != null && !cont.equals((Object)controller)) {
                return BlockPos.field_177992_a;
            }
            controller = cont;
        }
        return controller;
    }
}

