/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.blocks;

import com.ldtteam.storageracks.blocks.UpgradeableBlock;
import com.ldtteam.storageracks.gui.WindowHutAllInventory;
import com.ldtteam.storageracks.tileentities.TileEntityController;
import com.ldtteam.storageracks.tileentities.TileEntityRack;
import com.ldtteam.storageracks.utils.InventoryUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerBlock
extends UpgradeableBlock {
    private static final String BLOCK_NAME = "controller";
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    private final int tier;

    public ControllerBlock(String material, Item upgradeCost, int tier) {
        super(upgradeCost);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.setRegistryName("storageracks".toLowerCase() + ":" + material + "_" + BLOCK_NAME);
        this.tier = tier;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195999_j() == null ? Direction.NORTH : Direction.func_176733_a((double)context.func_195999_j().field_70177_z);
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing);
    }

    @NotNull
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public boolean func_200123_i(BlockState state, @NotNull IBlockReader reader, @NotNull BlockPos pos) {
        return true;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_190948_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)new TranslationTextComponent("block.storageracks.controllertoolip", new Object[]{this.tier * 20}));
    }

    @NotNull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_220062_a(BlockState state, ServerWorld worldIn, BlockPos pos, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRack) {
            IItemHandlerModifiable handler = ((TileEntityRack)tileentity).getInventory();
            InventoryUtils.dropItemHandler((IItemHandler)handler, (World)worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        super.func_220062_a(state, worldIn, pos, stack);
    }

    @NotNull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (world.field_72995_K) {
            new WindowHutAllInventory((TileEntityController)world.func_175625_s(pos)).open();
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityController();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && state.func_177230_c() instanceof ControllerBlock && placer instanceof PlayerEntity) {
            ((TileEntityController)world.func_175625_s(pos)).setTier(this.tier);
            for (Direction direction : Direction.values()) {
                TileEntity te = world.func_175625_s(pos.func_177972_a(direction));
                if (!(te instanceof TileEntityRack)) continue;
                ((TileEntityRack)te).neighborChange();
                return;
            }
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        boolean rem = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!world.field_72995_K && state.func_177230_c() instanceof ControllerBlock) {
            for (Direction direction : Direction.values()) {
                TileEntity te = world.func_175625_s(pos.func_177972_a(direction));
                if (!(te instanceof TileEntityRack)) continue;
                ((TileEntityRack)te).neighborChange();
            }
        }
        return rem;
    }

    public int getTier() {
        return this.tier;
    }
}

