/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.network;

import dan200.computercraft.api.network.IPacketSender;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Packet {
    private final int channel;
    private final int replyChannel;
    private final Object payload;
    private final IPacketSender sender;

    public Packet(int channel, int replyChannel, @Nullable Object payload, @Nonnull IPacketSender sender) {
        Objects.requireNonNull(sender, "sender cannot be null");
        this.channel = channel;
        this.replyChannel = replyChannel;
        this.payload = payload;
        this.sender = sender;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getReplyChannel() {
        return this.replyChannel;
    }

    @Nullable
    public Object getPayload() {
        return this.payload;
    }

    @Nonnull
    public IPacketSender getSender() {
        return this.sender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Packet packet = (Packet)o;
        if (this.channel != packet.channel) {
            return false;
        }
        if (this.replyChannel != packet.replyChannel) {
            return false;
        }
        if (!Objects.equals(this.payload, packet.payload)) {
            return false;
        }
        return this.sender.equals(packet.sender);
    }

    public int hashCode() {
        int result2 = this.channel;
        result2 = 31 * result2 + this.replyChannel;
        result2 = 31 * result2 + (this.payload != null ? this.payload.hashCode() : 0);
        result2 = 31 * result2 + this.sender.hashCode();
        return result2;
    }
}

