/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.LuaException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ArgumentHelper {
    private ArgumentHelper() {
    }

    @Nonnull
    public static String getType(@Nullable Object value) {
        if (value == null) {
            return "nil";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Map) {
            return "table";
        }
        return "userdata";
    }

    @Nonnull
    public static LuaException badArgumentOf(int index, @Nonnull String expected, @Nullable Object actual) {
        return ArgumentHelper.badArgument(index, expected, ArgumentHelper.getType(actual));
    }

    @Nonnull
    public static LuaException badArgument(int index, @Nonnull String expected, @Nonnull String actual) {
        return new LuaException("bad argument #" + (index + 1) + " (" + expected + " expected, got " + actual + ")");
    }

    public static double getDouble(@Nonnull Object[] args, int index) throws LuaException {
        if (index >= args.length) {
            throw ArgumentHelper.badArgument(index, "number", "nil");
        }
        Object value = args[index];
        if (!(value instanceof Number)) {
            throw ArgumentHelper.badArgumentOf(index, "number", value);
        }
        return ((Number)value).doubleValue();
    }

    public static int getInt(@Nonnull Object[] args, int index) throws LuaException {
        return (int)ArgumentHelper.getLong(args, index);
    }

    public static long getLong(@Nonnull Object[] args, int index) throws LuaException {
        if (index >= args.length) {
            throw ArgumentHelper.badArgument(index, "number", "nil");
        }
        Object value = args[index];
        if (!(value instanceof Number)) {
            throw ArgumentHelper.badArgumentOf(index, "number", value);
        }
        return ArgumentHelper.checkFinite(index, (Number)value).longValue();
    }

    public static double getFiniteDouble(@Nonnull Object[] args, int index) throws LuaException {
        return ArgumentHelper.checkFinite(index, ArgumentHelper.getDouble(args, index));
    }

    public static boolean getBoolean(@Nonnull Object[] args, int index) throws LuaException {
        if (index >= args.length) {
            throw ArgumentHelper.badArgument(index, "boolean", "nil");
        }
        Object value = args[index];
        if (!(value instanceof Boolean)) {
            throw ArgumentHelper.badArgumentOf(index, "boolean", value);
        }
        return (Boolean)value;
    }

    @Nonnull
    public static String getString(@Nonnull Object[] args, int index) throws LuaException {
        if (index >= args.length) {
            throw ArgumentHelper.badArgument(index, "string", "nil");
        }
        Object value = args[index];
        if (!(value instanceof String)) {
            throw ArgumentHelper.badArgumentOf(index, "string", value);
        }
        return (String)value;
    }

    @Nonnull
    public static Map<?, ?> getTable(@Nonnull Object[] args, int index) throws LuaException {
        if (index >= args.length) {
            throw ArgumentHelper.badArgument(index, "table", "nil");
        }
        Object value = args[index];
        if (!(value instanceof Map)) {
            throw ArgumentHelper.badArgumentOf(index, "table", value);
        }
        return (Map)value;
    }

    public static double optDouble(@Nonnull Object[] args, int index, double def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (!(value instanceof Number)) {
            throw ArgumentHelper.badArgumentOf(index, "number", value);
        }
        return ((Number)value).doubleValue();
    }

    public static int optInt(@Nonnull Object[] args, int index, int def) throws LuaException {
        return (int)ArgumentHelper.optLong(args, index, def);
    }

    public static long optLong(@Nonnull Object[] args, int index, long def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (!(value instanceof Number)) {
            throw ArgumentHelper.badArgumentOf(index, "number", value);
        }
        return ArgumentHelper.checkFinite(index, (Number)value).longValue();
    }

    public static double optFiniteDouble(@Nonnull Object[] args, int index, double def) throws LuaException {
        return ArgumentHelper.checkFinite(index, ArgumentHelper.optDouble(args, index, def));
    }

    public static boolean optBoolean(@Nonnull Object[] args, int index, boolean def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (!(value instanceof Boolean)) {
            throw ArgumentHelper.badArgumentOf(index, "boolean", value);
        }
        return (Boolean)value;
    }

    public static String optString(@Nonnull Object[] args, int index, String def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (!(value instanceof String)) {
            throw ArgumentHelper.badArgumentOf(index, "string", value);
        }
        return (String)value;
    }

    public static Map<?, ?> optTable(@Nonnull Object[] args, int index, Map<Object, Object> def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (!(value instanceof Map)) {
            throw ArgumentHelper.badArgumentOf(index, "table", value);
        }
        return (Map)value;
    }

    private static Number checkFinite(int index, Number value) throws LuaException {
        ArgumentHelper.checkFinite(index, value.doubleValue());
        return value;
    }

    private static double checkFinite(int index, double value) throws LuaException {
        if (!Double.isFinite(value)) {
            throw ArgumentHelper.badArgument(index, "number", ArgumentHelper.getNumericType(value));
        }
        return value;
    }

    @Nonnull
    public static String getNumericType(double value) {
        if (Double.isNaN(value)) {
            return "nan";
        }
        if (value == Double.POSITIVE_INFINITY) {
            return "inf";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        return "number";
    }
}

