/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmoney.shop;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbmoney.shop.Shop;
import dev.ftb.mods.ftbmoney.shop.ShopEntry;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class ShopTab
implements INBTSerializable<CompoundNBT> {
    public final Shop shop;
    public String title = "";
    public ItemStack icon = ItemStack.field_190927_a;
    public int lock = 0;
    public final List<ShopEntry> entries = new ArrayList<ShopEntry>();

    public ShopTab(Shop s) {
        this.shop = s;
    }

    public SNBTCompoundTag serializeSettings() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.func_74778_a("title", this.title);
        NBTUtils.write((CompoundNBT)nbt, (String)"icon", (ItemStack)this.icon);
        if (this.lock != 0) {
            nbt.func_74768_a("lock", this.lock);
        }
        return nbt;
    }

    public void deserializeSettings(CompoundNBT nbt) {
        this.title = nbt.func_74779_i("title");
        this.icon = NBTUtils.read((CompoundNBT)nbt, (String)"icon");
        this.lock = nbt.func_74762_e("lock");
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = this.serializeSettings();
        ListNBT e = new ListNBT();
        for (ShopEntry entry : this.entries) {
            e.add((Object)entry.serializeNBT());
        }
        nbt.func_218657_a("entries", (INBT)e);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.deserializeSettings(nbt);
        this.entries.clear();
        ListNBT e = nbt.func_150295_c("entries", 10);
        for (int i = 0; i < e.size(); ++i) {
            ShopEntry entry = new ShopEntry(this);
            entry.deserializeNBT(e.func_150305_b(i));
            if (entry.stack.func_190926_b()) continue;
            this.entries.add(entry);
        }
    }

    public int getIndex() {
        return this.shop.tabs.indexOf(this);
    }

    public void getConfig(ConfigGroup config) {
        config.addString("title", this.title, v -> {
            this.title = v;
        }, "");
        config.addItemStack("icon", this.icon, v -> {
            this.icon = v;
        }, ItemStack.field_190927_a, false, true);
    }
}

