/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmoney.shop;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbmoney.shop.ShopTab;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class ShopEntry
implements INBTSerializable<CompoundNBT> {
    public final ShopTab tab;
    public String page = "";
    public ItemStack stack = ItemStack.field_190927_a;
    public long buy = 0L;
    public long sell = 0L;
    public BlockPos stock = null;
    public RegistryKey<World> stockDimension = null;
    public UUID createdBy = null;
    public long lock = 0L;
    public boolean disabledServer = false;

    public ShopEntry(ShopTab t) {
        this.tab = t;
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        NBTUtils.write((CompoundNBT)nbt, (String)"item", (ItemStack)this.stack);
        if (this.buy > 0L) {
            nbt.func_74772_a("buy", this.buy);
        }
        if (this.sell > 0L) {
            nbt.func_74772_a("sell", this.sell);
        }
        if (this.stock != null && this.stockDimension != null) {
            nbt.func_74783_a("stock", new int[]{this.stock.func_177958_n(), this.stock.func_177956_o(), this.stock.func_177952_p()});
            nbt.func_74778_a("stock_dimension", this.stockDimension.func_240901_a_().toString());
        }
        if (this.createdBy != null) {
            nbt.func_74778_a("created_by", this.createdBy.toString());
        }
        if (this.lock != 0L) {
            nbt.func_74772_a("lock", this.lock);
        }
        if (this.disabledServer) {
            nbt.func_74757_a("disabled_server", true);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.page = nbt.func_74779_i("page");
        this.stack = NBTUtils.read((CompoundNBT)nbt, (String)"item");
        this.buy = nbt.func_74763_f("buy");
        this.sell = nbt.func_74763_f("sell");
        if (nbt.func_74764_b("") && nbt.func_74764_b("")) {
            int[] ai = nbt.func_74759_k("stock");
            this.stock = new BlockPos(ai[0], ai[1], ai[2]);
            this.stockDimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("stock_dimension")));
        } else {
            this.stock = null;
            this.stockDimension = null;
        }
        this.createdBy = nbt.func_74764_b("created_by") ? UUID.fromString(nbt.func_74779_i("created_by")) : null;
        this.lock = nbt.func_74763_f("lock");
        this.disabledServer = nbt.func_74767_n("disabled_server");
    }

    public boolean isUnlocked(@Nullable TeamData data) {
        if (this.lock == 0L) {
            return true;
        }
        if (data == null) {
            return false;
        }
        QuestObject object = this.tab.shop.file.get().get(this.lock);
        return object != null && data.isCompleted(object);
    }

    public void getConfig(ConfigGroup group) {
        group.addItemStack("item", this.stack, v -> {
            this.stack = v;
        }, ItemStack.field_190927_a, false, false);
        group.addLong("buy", this.buy, v -> {
            this.buy = v;
        }, 1L, 0L, Long.MAX_VALUE);
        group.addBool("disabled_server", this.disabledServer, v -> {
            this.disabledServer = v;
        }, false);
    }

    public int getIndex() {
        return this.tab.entries.indexOf(this);
    }
}

