/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmoney.shop;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbmoney.net.SyncShopMessage;
import dev.ftb.mods.ftbmoney.shop.ShopTab;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class Shop
implements INBTSerializable<CompoundNBT> {
    public static final Pattern PATTERN = Pattern.compile("\\W");
    public static Shop SERVER;
    public static Shop CLIENT;
    public final Supplier<QuestFile> file;
    public final List<ShopTab> tabs = new ArrayList<ShopTab>();
    public boolean shouldSave = false;

    public Shop(Supplier<QuestFile> f) {
        this.file = f;
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        ListNBT b = new ListNBT();
        for (ShopTab tab : this.tabs) {
            b.add((Object)tab.serializeNBT());
        }
        nbt.func_218657_a("tabs", (INBT)b);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.tabs.clear();
        ListNBT t = nbt.func_150295_c("tabs", 10);
        for (int i = 0; i < t.size(); ++i) {
            CompoundNBT n = t.func_150305_b(i);
            ShopTab tab = new ShopTab(this);
            tab.deserializeNBT(n);
            this.tabs.add(tab);
        }
    }

    public void markDirty() {
        this.shouldSave = true;
        if (this.file.get() != null && this.file.get().isServerSide()) {
            new SyncShopMessage((CompoundNBT)this.serializeNBT()).sendToAll(ServerQuestFile.INSTANCE.server);
        }
    }

    @Nullable
    public ShopTab getTab(String name) {
        String s = PATTERN.matcher(name).replaceAll("").toLowerCase();
        for (ShopTab tab : this.tabs) {
            if (!PATTERN.matcher(tab.title).replaceAll("").toLowerCase().equals(s)) continue;
            return tab;
        }
        for (ShopTab tab : this.tabs) {
            if (!PATTERN.matcher(tab.title).replaceAll("").toLowerCase().contains(s)) continue;
            return tab;
        }
        return null;
    }
}

