/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmoney.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftbmoney.gui.AddEntryButton;
import dev.ftb.mods.ftbmoney.gui.ShopEntryButton;
import dev.ftb.mods.ftbmoney.gui.ShopScreen;
import dev.ftb.mods.ftbmoney.shop.Shop;
import dev.ftb.mods.ftbmoney.shop.ShopEntry;
import dev.ftb.mods.ftbmoney.shop.ShopTab;
import java.util.ArrayList;

public class ShopEntryButtonsPanel
extends Panel {
    public final ShopScreen shopScreen;

    public ShopEntryButtonsPanel(ShopScreen g) {
        super((Panel)g);
        this.shopScreen = g;
    }

    public void add(Widget widget) {
        if (this.shopScreen.searchBox.getText().isEmpty() || widget.getTitle().getString().toLowerCase().contains(this.shopScreen.searchBox.getText().toLowerCase())) {
            super.add(widget);
        }
    }

    public void addWidgets() {
        ArrayList<ShopEntryButton> buttons = new ArrayList<ShopEntryButton>();
        ArrayList locked = new ArrayList();
        if (!this.shopScreen.searchBox.getText().isEmpty()) {
            for (ShopTab tab : Shop.CLIENT.tabs) {
                for (ShopEntry entry : tab.entries) {
                    ShopEntryButton b = new ShopEntryButton(this, entry);
                    (b.locked == 0 ? buttons : locked).add(b);
                }
            }
        } else if (this.shopScreen.selectedTab != null) {
            for (ShopEntry entry : this.shopScreen.selectedTab.entries) {
                ShopEntryButton b = new ShopEntryButton(this, entry);
                (b.locked == 0 ? buttons : locked).add(b);
            }
        }
        buttons.sort(ShopEntryButton.COMPARATOR);
        this.addAll(buttons);
        this.addAll(locked);
        if (this.shopScreen.selectedTab != null && Shop.CLIENT.file.get().canEdit()) {
            this.add((Widget)new AddEntryButton(this));
        }
    }

    public void alignWidgets() {
        this.setY(23);
        int prevWidth = this.width;
        if (this.widgets.isEmpty()) {
            this.setWidth(100);
        } else {
            this.setWidth(0);
            for (Widget w : this.widgets) {
                this.setWidth(Math.max(this.width, w.width));
            }
        }
        this.setWidth(Math.max(this.width, prevWidth));
        for (Widget w : this.widgets) {
            w.setX(1);
            w.setWidth(this.width - 2);
        }
        this.setHeight(140);
        this.shopScreen.scrollBar.setPosAndSize(this.posX + this.width + 6, this.posY - 1, 16, this.height + 2);
        this.shopScreen.scrollBar.setMaxValue((double)this.align((WidgetLayout)new WidgetLayout.Vertical(1, 1, 1)));
        this.shopScreen.setWidth(this.shopScreen.scrollBar.posX + this.shopScreen.scrollBar.width + 8);
        this.shopScreen.setHeight(this.height + 32);
        this.shopScreen.searchBox.setPosAndSize(8, 6, this.shopScreen.width - 16, 12);
    }

    public void drawBackground(MatrixStack poseStack, Theme theme, int x, int y, int w, int h) {
        theme.drawPanelBackground(poseStack, x, y, w, h);
    }
}

