/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmoney.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbmoney.FTBMoney;
import dev.ftb.mods.ftbmoney.gui.ShopScreen;
import dev.ftb.mods.ftbmoney.gui.SortType;
import dev.ftb.mods.ftbmoney.net.BuyMessage;
import dev.ftb.mods.ftbmoney.net.EditShopEntryMessage;
import dev.ftb.mods.ftbmoney.shop.ShopEntry;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ShopEntryButton
extends Button {
    public static final Comparator<ShopEntryButton> COMPARATOR = (o1, o2) -> SortType.sort.comparator.compare(o1.entry, o2.entry);
    public final ShopEntry entry;
    public final int locked;

    public ShopEntryButton(Panel panel, ShopEntry e) {
        super(panel, (ITextComponent)new StringTextComponent("").func_230529_a_(e.stack.func_200301_q()).func_240699_a_(e.stack.func_77953_t().field_77937_e), ItemIcon.getItemIcon((ItemStack)e.stack));
        this.entry = e;
        QuestObject lock = ClientQuestFile.INSTANCE.get(this.entry.lock);
        this.locked = this.entry.lock == 0L || lock != null && ClientQuestFile.INSTANCE.self.isCompleted(lock) ? (this.entry.disabledServer && !Minecraft.func_71410_x().func_71356_B() ? 1 : 0) : 2;
        this.setWidth(Math.max(panel.getGui().getTheme().getStringWidth((ITextProperties)this.title), panel.getGui().getTheme().getStringWidth(FTBMoney.moneyString(this.entry.buy))) + 32);
        this.setHeight(24);
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        ShopScreen gui = (ShopScreen)this.getGui();
        if (button.isLeft()) {
            if (this.locked == 0 || this.entry.tab.shop.file.get().canEdit()) {
                IntConfig count = new IntConfig(1, (int)Math.min(1024L, this.entry.buy <= 0L ? 1024L : FTBMoney.getClientMoney() / this.entry.buy));
                count.value = 1;
                count.onClicked(button, set -> {
                    gui.openGui();
                    if (set) {
                        new BuyMessage(this.entry, (Integer)count.value).sendToServer();
                    }
                });
            }
        } else if (button.isRight() && this.entry.tab.shop.file.get().canEdit()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.edit"), Icons.SETTINGS, () -> {
                ConfigGroup group = new ConfigGroup("ftbmoney").setNameKey("sidebar_button.ftbmoney.shop");
                group.savedCallback = b -> {
                    this.openGui();
                    if (b) {
                        new EditShopEntryMessage(this.entry, false).sendToServer();
                    }
                };
                ConfigGroup g = group.getGroup("shop").getGroup("entry");
                this.entry.getConfig(g);
                new EditConfigScreen(group).openGui();
                gui.refreshWidgets();
            }));
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.delete"), Icons.REMOVE, () -> gui.openYesNo((ITextComponent)new TranslationTextComponent("delete_item", new Object[]{this.entry.stack.func_200301_q()}), StringTextComponent.field_240750_d_, () -> {
                new EditShopEntryMessage(this.entry, true).sendToServer();
                this.entry.tab.entries.remove(this.entry);
                gui.refreshWidgets();
            })));
            gui.openContextMenu(contextMenu);
        }
    }

    public WidgetType getWidgetType() {
        if (this.locked > 0 && !this.entry.tab.shop.file.get().canEdit()) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void addMouseOverText(TooltipList list) {
        if (this.locked == 2) {
            list.string("Locked!");
            QuestObject object = ClientQuestFile.INSTANCE.get(this.entry.lock);
            if (object != null) {
                list.add((ITextComponent)new StringTextComponent("Requires: ").func_230529_a_(object.getTitle()));
            }
        }
        if (this.locked < 2 || this.entry.tab.shop.file.get().canEdit()) {
            if (this.entry.disabledServer && !Minecraft.func_71410_x().func_71356_B()) {
                list.add((ITextComponent)new TranslationTextComponent("ftbmoney.shop.entry.disabled_server").func_240699_a_(TextFormatting.RED));
            }
            ArrayList list1 = new ArrayList();
            GuiHelper.addStackTooltip((ItemStack)this.entry.stack, list1);
            list1.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
        }
    }

    public void draw(MatrixStack poseStack, Theme theme, int x, int y, int w, int h) {
        this.drawBackground(poseStack, theme, x, y, w, h);
        if (this.locked == 2 && !this.entry.tab.shop.file.get().canEdit()) {
            Icons.LOCK.draw(poseStack, x + 4, y + 4, 16, 16);
            theme.drawString(poseStack, (Object)"???", (float)(x + 24), (float)(y + 3), theme.getContentColor(this.getWidgetType()), 2);
            theme.drawString(poseStack, (Object)new StringTextComponent("").func_230529_a_(FTBMoney.moneyComponent(999999999L)).func_240699_a_(TextFormatting.OBFUSCATED), (float)(x + 24), (float)(y + 13), Color4I.WHITE, 2);
            return;
        }
        this.drawIcon(poseStack, theme, x + 4, y + 4, 16, 16);
        theme.drawString(poseStack, (Object)theme.trimStringToWidth((ITextProperties)this.title, w - 24), (float)(x + 24), (float)(y + 3), theme.getContentColor(this.getWidgetType()), 2);
        theme.drawString(poseStack, (Object)FTBMoney.moneyComponent(this.entry.buy), (float)(x + 24), (float)(y + 13), Color4I.WHITE, 2);
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.locked < 2 ? this.entry.stack : null;
    }
}

