/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instructions;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.instructions.TickingInstruction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;

public class EmitParticlesInstruction
extends TickingInstruction {
    private Vector3d anchor;
    private Emitter emitter;
    private float runsPerTick;

    public EmitParticlesInstruction(Vector3d anchor, Emitter emitter, float runsPerTick, int ticks) {
        super(false, ticks);
        this.anchor = anchor;
        this.emitter = emitter;
        this.runsPerTick = runsPerTick;
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        int runs = (int)this.runsPerTick;
        if (Create.RANDOM.nextFloat() < this.runsPerTick - (float)runs) {
            ++runs;
        }
        for (int i = 0; i < runs; ++i) {
            this.emitter.create(scene.getWorld(), this.anchor.field_72450_a, this.anchor.field_72448_b, this.anchor.field_72449_c);
        }
    }

    @FunctionalInterface
    public static interface Emitter {
        public static <T extends IParticleData> Emitter simple(T data, Vector3d motion) {
            return (w, x, y, z) -> w.func_195594_a(data, x, y, z, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        }

        public static <T extends IParticleData> Emitter withinBlockSpace(T data, Vector3d motion) {
            return (w, x, y, z) -> w.func_195594_a(data, Math.floor(x) + (double)Create.RANDOM.nextFloat(), Math.floor(y) + (double)Create.RANDOM.nextFloat(), Math.floor(z) + (double)Create.RANDOM.nextFloat(), motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        }

        public static ParticleManager paticleManager() {
            return Minecraft.func_71410_x().field_71452_i;
        }

        public void create(PonderWorld var1, double var2, double var4, double var6);
    }
}

