/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.IScreenRenderable;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;

public class PonderChapter
implements IScreenRenderable {
    private final ResourceLocation id;
    private final ResourceLocation icon;

    private PonderChapter(ResourceLocation id) {
        this.id = id;
        this.icon = new ResourceLocation(id.func_110624_b(), "textures/ponder/chapter/" + id.func_110623_a() + ".png");
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getTitle() {
        return PonderLocalization.getChapter(this.id);
    }

    public PonderChapter addTagsToChapter(PonderTag ... tags) {
        for (PonderTag t : tags) {
            PonderRegistry.TAGS.add(t, this);
        }
        return this;
    }

    @Override
    public void draw(MatrixStack ms, AbstractGui screen, int x, int y) {
        ms.func_227860_a_();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.icon);
        ms.func_227862_a_(0.25f, 0.25f, 1.0f);
        AbstractGui.func_238464_a_((MatrixStack)ms, (int)x, (int)y, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        ms.func_227865_b_();
    }

    @Nonnull
    public static PonderChapter of(ResourceLocation id) {
        PonderChapter chapter = PonderRegistry.CHAPTERS.getChapter(id);
        if (chapter == null) {
            chapter = PonderRegistry.CHAPTERS.addChapter(new PonderChapter(id));
        }
        return chapter;
    }
}

